% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klein-bottles.r
\name{klein-bottles}
\alias{klein-bottles}
\alias{sample_klein_tube}
\alias{sample_klein_flat}
\title{Sample (with noise) from Klein bottles}
\usage{
sample_klein_tube(n, ar = 2, sd = 0)

sample_klein_flat(n, ar = 1, bump = 0.1, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{ar}{Aspect ratio for Möbius tube Klein bottle (ratio of major and minor
radii) or flat torus-based Klein bottle (ratio of scale factors).}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}

\item{bump}{Bump constant for the flat torus-based Klein bottle.}
}
\description{
These functions generate uniform samples from Klein bottles in
4-dimensional space, optionally with noise.
}
\details{
The function \code{sample_klein_tube()} uses the Möbius tube parameterization
documented at the \href{https://mathcurve.com/surfaces.gb/klein/klein.shtml}{Encyclopédie des Formes Mathématiques Remarquables}.

The function \code{sample_klein_flat()} uses a flat parameterization based on that
of the torus, as presented on
\href{https://en.wikipedia.org/wiki/Klein_bottle#4-D_non-intersecting}{Wikipedia}.

Both uniform samples are generated through a rejection sampling process as
described by Diaconis, Holmes, and Shahshahani (2013).
}
\examples{
set.seed(834L)

# Klein bottle tube embedding in 4-space
x <- sample_klein_tube(120, sd = .05)
pairs(x, asp = 1, pch = 19, cex = .5)

# Klein bottle flat torus-based embedding in 4-space
x <- sample_klein_flat(120, sd = .05)
pairs(x, asp = 1, pch = 19, cex = .5)
}
\references{
P Diaconis, S Holmes, and M Shahshahani (2013) Sampling from a Manifold.
\emph{Advances in Modern Statistical Theory and Applications: A Festschrift in
honor of Morris L. Eaton}, 102--125. \doi{10.1214/12-IMSCOLL1006}
}
