% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{pkmod2cpt}
\alias{pkmod2cpt}
\title{Two compartment IV infusion with first-order elimination.}
\usage{
pkmod2cpt(tm, kR, pars, init = c(0, 0))
}
\arguments{
\item{tm}{Vector of times to evaluate the PK function at}

\item{kR}{Infusion rate (e.g. ml/min).}

\item{pars}{Named vector of parameters with names ('K10','K12','K21','V1','V2') or ('CL','Q','V1','V2').}

\item{init}{Initial concentration. Defaults to 0 in both compartments.}
}
\value{
Numeric matrix of concentrations for a constant infusion rate
}
\description{
Two compartment IV infusion with first-order elimination. Elimination from peripheral compartment
is assumed to be zero unless 'k20' is specified.
}
\examples{
pkmod2cpt(1,1,c(CL = 15, V1 = 10, Q2 = 10, V2 = 20))
pkmod2cpt(1,1,c(CL = 15, v1 = 10, Q2 = 10, V2 = 20, cl2 = 4))
}
