% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/segments.R
\name{freq.segments}
\alias{freq.Ja}
\alias{freq.Jb}
\alias{freq.Va}
\alias{freq.Vb}
\alias{freq.segments}
\alias{freq.segments.2D}
\title{V- and J-segments frequency.}
\usage{
freq.segments(.data, .alphabet = 'TRBV', .count = F, .meat = F, .other = T,
              .laplace = 1, .column = NULL, .sum.col = "Read.count")

freq.segments.2D(.data, .alphabet = 'beta', .count = F, .meat = F,
                 .laplace = 1, .columns = NULL, .sum.col = "Read.count", ...)

freq.Va(.data, .count = F, .meat = F, .other = T, .laplace = 1, .sum.col = "Read.count")

freq.Vb(.data, .count = F, .meat = F, .other = T, .laplace = 1, .sum.col = "Read.count")

freq.Ja(.data, .count = F, .meat = F, .other = T, .laplace = 1, .sum.col = "Read.count")

freq.Jb(.data, .count = F, .meat = F, .other = T, .laplace = 1, .sum.col = "Read.count")
}
\arguments{
\item{.data}{Mitcr data.frame or list with data.frames.}

\item{.alphabet}{Vector of elements in the alphabet for freq.segments, one of the strings 'TRBV' (for using V_BETA_ALPHABET variable, that user should load before calling functions (same for other strings)), 'TRAV', 'TRBJ', 'TRAJ' for V- and J-segments alphabets for freq.segments
or one of the 'alpha' or 'beta' for freq.segments.2D or a list of length 2 with alphabets strings for freq.segments.2D.}

\item{.count}{Should we return count or percentage?}

\item{.meat}{Compute statistics using counts of elements (e.g., Read.count) or not.}

\item{.other}{Should elements not in the given alphabet be shown in the result matrix.}

\item{.laplace}{Value for the Laplace correction.}

\item{.column,.columns}{Column's name with elements from the given alphabet for the freq.segments or a character vector of length two for freq.segments.2D.}

\item{.sum.col}{Which column use to count frequencies if \code{.meat} = T. Default: 'Read.count'.}

\item{...}{Don't use it, for internal purpose.}
}
\value{
Data.frame with columns Segments and their frequencies in the column Freq.
}
\description{
Get frequencies or counts of segments (V / J - usage).
}
\examples{
\dontrun{
# Load your data
data(twb)
# Load human alphabets
data(human.alphabets)
# compute V-segments frequencies
seg <- freq.segments(twb)
# plot V-segments frequencies as a grid
vis.grid.stats(seg)
# plot V-segments frequencies from the data
vis.V.usage(twb)
}
}
\seealso{
\code{\link{vis.V.usage}} \code{\link{vis.J.usage}} \code{\link{pca.segments}}
}

