% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_median.R
\name{median_ci}
\alias{median_ci}
\title{Returns the median and CI}
\usage{
median_ci(
  window,
  conf = 0.95,
  na.rm = TRUE,
  type = "basic",
  R = 1000,
  parallel = "no",
  ncpus = getOption("boot.ncpus", 1L),
  cl = NULL
)
}
\arguments{
\item{window}{vector of data values}

\item{conf}{confidence level of the required interval. \code{NA} if skipping
calculating the bootstrapped CI}

\item{na.rm}{logical code{TRUE/FALSE}. Remove NAs from the dataset. Defaults
\code{TRUE}}

\item{type}{character string, one of \code{c("norm","basic", "stud", "perc",
"bca")}. \code{"all"} is not a valid value. See \code{\link{boot.ci}}}

\item{R}{the number of bootstrap replicates. see \code{\link{boot}}}

\item{parallel}{The type of parallel operation to be used (if any). see
\code{\link{boot}}}

\item{ncpus}{integer: number of process to be used in parallel operation. see
\code{\link{boot}}}

\item{cl}{optional parallel or snow cluster for use if \code{parallel =
"snow"}. see \code{\link{boot}}}
}
\value{
named list with mean and (optionally) specified confidence
  interval
}
\description{
Generates median and confidence intervals using bootstrap.
}
\keyword{internal}
