% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_taxa}
\alias{get_taxa}
\title{A helper function to filter on GBIF and NCBI taxa names}
\usage{
get_taxa(
  x,
  kingdom = NA,
  phylum = NA,
  class = NA,
  order = NA,
  family = NA,
  genus = NA,
  species = NA
)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{kingdom}{A string consisting of a scientific name.}

\item{phylum}{A string consisting of a scientific name.}

\item{class}{A string consisting of a scientific name.}

\item{order}{A string consisting of a scientific name.}

\item{family}{A string consisting of a scientific name.}

\item{genus}{A string consisting of a scientific name.}

\item{species}{A string consisting of a scientific name.}
}
\value{
A filtered tibble.
}
\description{
A helper function to filter on GBIF and NCBI taxa names
}
\details{
This method will return results if the scientific name of interest is
found in either the GBIF or the NCBI. The scientific name does not have to be
case sensitive.
}
\examples{
get_taxa(load_sample(), species = "hyalina")
get_taxa(load_sample(), phylum = "ArthroPODA", genus = "BirGus")
}
