% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissect_name.R
\name{dissect_name}
\alias{dissect_name}
\title{Dissect Scientific Names into their Elements}
\usage{
dissect_name(x, split = " ", fixed = TRUE, repaste, ...)
}
\arguments{
\item{x}{A character vector containing taxon names.}

\item{split, fixed, ...}{Arguments passed to \code{\link[=strsplit]{strsplit()}}.}

\item{repaste}{An integer vector indicating the elements of the name selected
for the output.}
}
\value{
A character matrix with as many rows as names in the input vector.
If \code{repaste} is indicated, then the output will be a character vector.
}
\description{
Depending the degree of resolution and specific roles of nomenclature,
strings containing taxon usage names (scientific names) are constructed with
different parts.
A string with names can be consequently split into those elements, meanwhile
the number of elements may suggest the taxonomic ranks.

This function is a wrapper of \code{\link[=strsplit]{strsplit()}}, while name element can be
re-pasted if indicated in argument \code{repaste}.
}
\examples{
# A list of variety names
sp_list <- subset(x = Easplist, subset = Level == "variety", slot = "relations")
sp_list <- accepted_name(sp_list)[c(1:10), "TaxonName"]

# split name
dissect_name(sp_list)

# re-paste the two first words (species name)
dissect_name(sp_list, repaste = c(1:2))
}
\seealso{
\code{\link[=strsplit]{strsplit()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
