% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_download.R
\name{db_download}
\alias{db_download}
\alias{db_download_ncbi}
\alias{db_download_itis}
\alias{db_download_tpl}
\alias{db_download_wfo}
\alias{db_download_col}
\alias{db_download_gbif}
\alias{db_download_wikidata}
\title{Download taxonomic databases}
\usage{
db_download_ncbi(verbose = TRUE)

db_download_itis(verbose = TRUE)

db_download_tpl(verbose = TRUE)

db_download_wfo(verbose = TRUE)

db_download_col(verbose = TRUE)

db_download_gbif(verbose = TRUE)

db_download_wikidata(verbose = TRUE)
}
\arguments{
\item{verbose}{(logical) Print messages. Default: \code{TRUE}}
}
\value{
(character) path to the downloaded SQL database
}
\description{
Download taxonomic databases
}
\details{
Downloads sql database, cleans up unneeded files, returns path
to sql file
}
\examples{
\dontrun{
# ITIS
# db_download_itis()
# src_itis()

# Plantlist
# db_download_tpl()
# src_tpl()

# COL
# db_download_col()
# src_col()

# GBIF
# db_download_gbif()
# src_gbif()

# NCBI
# db_download_ncbi()
# src_ncbi()

# Wikidata
# db_download_wikidata()
# src_wikidata()

# World Flora Online
# db_download_wfo()
# src_wfo()
}
}
\seealso{
\link{tdb_cache}
}
