% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tpl_get.r
\name{tpl_get}
\alias{tpl_get}
\title{Get The Plant List csv files.}
\usage{
tpl_get(x, family = NULL)
}
\arguments{
\item{x}{Directory to write csv files to.}

\item{family}{If you want just one, or >1 family, but not all, list them in
a vector.}
}
\value{
Returns nothing to console, except a message and progress bar.
Writes csv files to x.
}
\description{
Get The Plant List csv files.
}
\details{
Throws a warning if you already have a directory of the one
provided, but still works. Writes to your home directory, change dir_ as needed.
}
\examples{
\dontrun{
# Get a few families
tpl_get("~/foo2", family = c("Platanaceae","Winteraceae"))

# You can now get Gymnosperms as well
tpl_get("~/foo2", family = c("Pinaceae","Taxaceae"))

# You can get mosses too!
tpl_get("~/foo4", family = "Echinodiaceae")

# Get all families
## Beware, will take a while
## tpl_get("~/foo")
}
}
\author{
John Baumgartner (johnbb@student.unimelb.edu.au)
}
\references{
The Plant List \url{http://www.theplantlist.org/}
}
\seealso{
\code{\link{tpl_families}}
}

