% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{sample_n_taxa}
\alias{sample_n_taxa}
\title{Sample n taxa from \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}}
\arguments{
\item{obj}{(\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}) The object to sample from.}

\item{size}{(\code{numeric} of length 1) The number of taxa to sample.}

\item{taxon_weight}{(\code{numeric}) Non-negative sampling weights of each
taxon. If \code{obs_weight} is also specified, the two weights are
multiplied (after \code{obs_weight} for each taxon is calculated).}

\item{obs_weight}{(\code{numeric})  This option only applies to \code{\link[=taxmap]{taxmap()}}
objects. Sampling weights of each observation. The weights for each
observation assigned to a given taxon are supplied to \code{collapse_func} to
get the taxon weight. If \code{use_subtaxa} is \code{TRUE} then the observations
assigned to every subtaxa are also used. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own. If
\code{taxon_weight} is also specified, the two weights are multiplied (after
\code{obs_weight} for each observation is calculated). \code{obs_target} must be used
with this option.}

\item{obs_target}{(\code{character} of length 1)  This option only applies to
\code{\link[=taxmap]{taxmap()}} objects. The name of the data set in \code{obj$data} that values in
\code{obs_weight} corresponds to. Must be used when \code{obs_weight} is used.}

\item{use_subtaxa}{(\code{logical} or \code{numeric} of length 1) Affects how the
\code{obs_weight} option is used. If \code{TRUE}, the weights for each taxon in an
observation's classification are multiplied to get the observation weight.
If \code{FALSE} just the taxonomic level the observation is assign to it
considered. Positive numbers indicate the number of ranks below the each
taxon to use. \code{0} is equivalent to \code{FALSE}. Negative numbers are equivalent
to \code{TRUE}.}

\item{collapse_func}{(\code{function} of length 1) If \code{taxon_weight} is used and
\code{supertaxa} is \code{TRUE}, the weights for each taxon in an observation's
classification are supplied to \code{collapse_func} to get the observation
weight. This function should take  numeric vector and return a single
number.}

\item{...}{Additional options are passed to \code{\link[=filter_taxa]{filter_taxa()}}.}
}
\value{
An object of type \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}
}
\description{
Randomly sample some number of taxa from a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.
Weights can be specified for taxa or the observations assigned to them. See
\code{\link[dplyr:sample_n]{dplyr::sample_n()}} for the inspiration for this function.
\preformatted{
obj$sample_n_taxa(size, taxon_weight = NULL,
  obs_weight = NULL, obs_target = NULL,
  use_subtaxa = TRUE, collapse_func = mean, ...)
sample_n_taxa(obj, size, taxon_weight = NULL,
  obs_weight = NULL, obs_target = NULL,
  use_subtaxa = TRUE, collapse_func = mean, ...)}
}
\examples{
# Randomly sample three taxa
sample_n_taxa(ex_taxmap, 3)

# Include supertaxa
sample_n_taxa(ex_taxmap, 3, supertaxa = TRUE)

# Include subtaxa
sample_n_taxa(ex_taxmap, 1, subtaxa = TRUE)

# Sample some taxa more often then others
sample_n_taxa(ex_taxmap, 3, supertaxa = TRUE,
              obs_weight = n_legs, obs_target = "info")

}
\seealso{
Other taxmap manipulation functions: 
\code{\link{arrange_obs}()},
\code{\link{arrange_taxa}()},
\code{\link{filter_obs}()},
\code{\link{filter_taxa}()},
\code{\link{mutate_obs}()},
\code{\link{sample_frac_obs}()},
\code{\link{sample_frac_taxa}()},
\code{\link{sample_n_obs}()},
\code{\link{select_obs}()},
\code{\link{transmute_obs}()}
}
\concept{taxmap manipulation functions}
