% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_sl.R
\name{learner_sl}
\alias{learner_sl}
\title{Construct a learner}
\usage{
learner_sl(
  learners,
  info = NULL,
  nfolds = 5L,
  meta.learner = metalearner_nnls,
  model.score = mse,
  learner.args = NULL,
  ...
)
}
\arguments{
\item{learners}{(list) List of \link{learner} objects (i.e. \link{learner_glm})}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{nfolds}{(integer) Number of folds to use in cross-validation to
estimate the ensemble weights.}

\item{meta.learner}{(function) Algorithm to learn the ensemble weights
(default non-negative least squares). Must be a function of the response
(nx1 vector), \code{y}, and the predictions (nxp matrix), \code{pred}, with p being
the number of learners. Alternatively, this can be set to the character
value "discrete", in which case the Discrete Super-Learner is applied where
the model with the lowest risk (model-score) is given weight 1 and all
other learners weight 0.}

\item{model.score}{(function) Model scoring method (see \link{learner})}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link{superlearner}}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting a
\link{superlearner}.
}
\examples{
sim1 <- function(n = 5e2) {
   x1 <- rnorm(n, sd = 2)
   x2 <- rnorm(n)
   y <- x1 + cos(x1) + rnorm(n, sd = 0.5**.5)
   data.frame(y, x1, x2)
}
d <- sim1()

m <- list(
  "mean" = learner_glm(y ~ 1),
  "glm" = learner_glm(y ~ x1 + x2),
  "iso" = learner_isoreg(y ~ x1)
)

s <- learner_sl(m, nfolds = 10)
s$estimate(d)
pr <- s$predict(d)
if (interactive()) {
    plot(y ~ x1, data = d)
    points(d$x1, pr, col = 2, cex = 0.5)
    lines(cos(x1) + x1 ~ x1, data = d[order(d$x1), ],
          lwd = 4, col = lava::Col("darkblue", 0.3))
}
print(s)
# weights(s$fit)
# score(s$fit)

cvres <- cv(s, data = d, nfolds = 3, rep = 2)
cvres
# coef(cvres)
# score(cvres)
}
\seealso{
\link{cv.learner_sl}
}
