% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate.R
\name{ate}
\alias{ate}
\alias{aipw}
\title{AIPW estimator for Average Treatement Effect}
\usage{
ate(
  formula,
  data = parent.frame(),
  weights,
  binary = TRUE,
  nuisance = NULL,
  propensity = nuisance,
  all,
  missing = FALSE,
  labels = NULL,
  ...
)
}
\arguments{
\item{formula}{Formula (see details below)}

\item{data}{data.frame}

\item{weights}{optional frequency weights}

\item{binary}{Binary response (default TRUE)}

\item{nuisance}{outcome regression formula}

\item{propensity}{propensity model formula}

\item{all}{If TRUE all standard errors are calculated (default TRUE when exposure
only has two levels)}

\item{missing}{If TRUE a missing data (AIPW) estimator is returned}

\item{labels}{Optional treatment labels}

\item{...}{Additional arguments to lower level functions}
}
\value{
An object of class '\code{ate.targeted}' is returned. See \code{\link{targeted-class}}
for more details about this class and its generic functions.
}
\description{
Augmented Inverse Probability Weighting estimator for the Average (Causal) Treatment Effect.
}
\details{
The formula may either be specified as:
response ~ treatment | nuisance-formula | propensity-formula

For example: \code{ate(y~a | x+z+a | x*z, data=...)}

Alternatively, as a list: \code{ate(list(y~a, ~x+z, ~x*z), data=...)}

Or using the nuisance (and propensity argument): \code{ate(y~a, nuisance=~x+z, ...)}
}
\examples{
m <- lvm(y ~ a+x, a~x)
distribution(m,~ a+y) <- binomial.lvm()
d <- sim(m,1e3,seed=1)

a <- ate(y ~ a, nuisance=~x, data=d)
summary(a)

# Multiple treatments
m <- lvm(y ~ a+x, a~x)
distribution(m,~ y) <- binomial.lvm()
m <- ordinal(m, K=4, ~a)
transform(m, ~a) <- factor
d <- sim(m, 1e4, seed=1)
(a <- ate(y~a|a*x|x, data=d))

# Comparison with randomized experiment
m0 <- cancel(m, a~x)
d0 <- sim(m0,2e5)
lm(y~a-1,d0)

# Choosing a different contrast for the association measures
summary(a, contrast=c(2,4))
}
\author{
Klaus K. Holst
}
