% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/similarity.R
\docType{methods}
\name{similarity}
\alias{similarity}
\alias{similarity-method}
\alias{similarity,matrix-method}
\alias{similarity,data.frame-method}
\title{Similarity}
\usage{
similarity(object, ...)

\S4method{similarity}{matrix}(
  object,
  method = c("brainerd", "bray", "jaccard", "morisita", "sorensen")
)

\S4method{similarity}{data.frame}(
  object,
  method = c("brainerd", "bray", "jaccard", "morisita", "sorensen")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Currently not used.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}
}
\value{
A \link[stats:dist]{stats::dist} object.
}
\description{
Similarity
}
\details{
\eqn{\beta}-diversity can be measured by addressing \emph{similarity}
between pairs of samples/cases.

\code{bray}, \code{jaccard}, \code{morisita} and \code{sorensen} indices provide a scale of
similarity from \eqn{0}-\eqn{1} where \eqn{1} is perfect similarity and
\eqn{0} is no similarity.
\code{brainerd} is scaled between \eqn{0} and \eqn{200}.

\describe{
\item{\code{brainerd}}{\link[=index_brainerd]{Brainerd-Robinson quantitative index}.}
\item{\code{bray}}{\link[=index_bray]{Bray-Curtis similarity (a.k.a. Dice-Sorensen quantitative index)}.}
\item{\code{jaccard}}{\link[=index_jaccard]{Jaccard qualitative index}.}
\item{\code{morisita}}{\link[=index_morisita]{Morisita-Horn quantitative index}.}
\item{\code{sorensen}}{\link[=index_sorensen]{Dice-Sorensen qualitative index}.}
}

For \code{jaccard} and \code{sorensen}, data are standardized on a presence/absence
scale (\eqn{0}/\eqn{1}) beforehand.
}
\examples{
## Data from Huntley 2004, 2008
data("pueblo")

## Brainerd-Robinson measure
(C <- similarity(pueblo, "brainerd"))
plot_spot(C)

## Data from Magurran 1988, p. 166
data("aves")

## Jaccard measure (presence/absence data)
similarity(aves, "jaccard") # 0.46

# Bray and Curtis modified version of the Sorensen index (count data)
(sim <- similarity(aves, "bray")) # 0.44

# Bray and Curtis dissimilarity
1 - sim
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.
}
\seealso{
\code{\link[=index_binomial]{index_binomial()}}, \code{\link[=index_brainerd]{index_brainerd()}}, \code{\link[=index_bray]{index_bray()}},
\code{\link[=index_jaccard]{index_jaccard()}}, \code{\link[=index_morisita]{index_morisita()}}, \code{\link[=index_sorensen]{index_sorensen()}}

Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
