% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.watching.R
\name{trakt.show.watching}
\alias{trakt.show.watching}
\title{Get users watching a show}
\usage{
trakt.show.watching(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{data.frame} containing user information
}
\description{
\code{trakt.show.watching} returns trakt.tv users who are watching this show.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/shows/watching/get-users-watching-right-now}{the
 trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.show.watching("breaking-bad")
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

