/*
 * Decompiled with CFR 0.152.
 */
package ibd;

import blbutil.IndexMap;
import blbutil.IntList;
import haplotype.HapPairs;
import haplotype.SampleHapPairs;
import ibd.HapSegment;
import ibd.Haplotype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IbsHapSegments {
    private static final int INIT_LIST_SIZE = 500;
    private final SampleHapPairs haps;
    private final double[] pos;
    private final double minLength;
    private final int[] windowStarts;
    private final int[][][] idSets;
    private final int DEL = -67;

    public IbsHapSegments(SampleHapPairs sampleHapPairs, double[] dArray, double d) {
        IbsHapSegments.checkArguments(sampleHapPairs, dArray, d);
        this.haps = sampleHapPairs;
        this.pos = (double[])dArray.clone();
        this.minLength = d;
        this.windowStarts = IbsHapSegments.windowStarts(dArray, d);
        this.idSets = IbsHapSegments.idSets(sampleHapPairs, this.windowStarts);
    }

    public IbsHapSegments(SampleHapPairs sampleHapPairs, int n) {
        this(sampleHapPairs, IbsHapSegments.pos(sampleHapPairs.nMarkers()), n);
    }

    private static double[] pos(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i;
        }
        return dArray;
    }

    private static void checkArguments(SampleHapPairs sampleHapPairs, double[] dArray, double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("minLength: " + d);
        }
        if (sampleHapPairs.nMarkers() != dArray.length) {
            throw new IllegalArgumentException("haps.nMarkers()!= pos.length");
        }
        if (dArray[0] < 0.0 || Double.isNaN(dArray[0]) || Double.isInfinite(dArray[0])) {
            throw new IllegalArgumentException("pos=" + dArray[0]);
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) {
                throw new IllegalArgumentException("pos=" + dArray[i]);
            }
            if (!(dArray[i] < dArray[i - 1])) continue;
            String string = "positions are not non-decreasing";
            throw new IllegalArgumentException(string);
        }
    }

    private static int[] windowStarts(double[] dArray, double d) {
        int n;
        double d2;
        double d3 = d / 2.0;
        IntList intList = new IntList(dArray.length / 10);
        double d4 = dArray[dArray.length - 1] - 2.0 * d3;
        int n2 = 0;
        intList.add(n2);
        while (dArray[n2] < d4) {
            d2 = dArray[n2] + d3;
            n = IbsHapSegments.nextIndex(dArray, n2, d2);
            intList.add(n);
            n2 = n;
        }
        d2 = (dArray[n2] + dArray[dArray.length - 1]) / 2.0;
        n = IbsHapSegments.nextIndex(dArray, n2, d2);
        intList.add(n);
        return intList.toArray();
    }

    private static int nextIndex(double[] dArray, int n, double d) {
        int n2 = Arrays.binarySearch(dArray, n, dArray.length, d);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static int[][][] idSets(SampleHapPairs sampleHapPairs, int[] nArray) {
        int[][][] nArray2 = new int[nArray.length][sampleHapPairs.nHaps()][];
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            int n2 = i + 1 < nArray.length ? nArray[i + 1] : sampleHapPairs.nMarkers();
            List<Haplotype> list = IbsHapSegments.hapList(sampleHapPairs, n, n2);
            Map<Haplotype, IntList> map = IbsHapSegments.dictionary(list);
            IbsHapSegments.fillIdSet(map, nArray2[i]);
        }
        return nArray2;
    }

    private static List<Haplotype> hapList(SampleHapPairs sampleHapPairs, int n, int n2) {
        ArrayList<Haplotype> arrayList = new ArrayList<Haplotype>(sampleHapPairs.nHaps());
        int n3 = sampleHapPairs.nHaps();
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new Haplotype(sampleHapPairs, i, n, n2));
        }
        return arrayList;
    }

    private static Map<Haplotype, IntList> dictionary(List<Haplotype> list) {
        HashMap<Haplotype, IntList> hashMap = new HashMap<Haplotype, IntList>();
        for (Haplotype haplotype : list) {
            IntList intList = (IntList)hashMap.get(haplotype);
            if (intList == null) {
                intList = new IntList(10);
                hashMap.put(haplotype, intList);
            }
            intList.add(haplotype.hapIndex());
        }
        return hashMap;
    }

    private static void fillIdSet(Map<Haplotype, IntList> map, int[][] nArray) {
        for (Haplotype haplotype : map.keySet()) {
            int[] nArray2;
            for (int n : nArray2 = map.get(haplotype).toArray()) {
                nArray[n] = nArray2;
            }
        }
    }

    public SampleHapPairs haps() {
        return this.haps;
    }

    public double[] pos() {
        return (double[])this.pos.clone();
    }

    public double minIbsLength() {
        return this.minLength;
    }

    public List<HapSegment> find(int n) {
        ArrayList<HapSegment> arrayList = new ArrayList<HapSegment>(500);
        IndexMap indexMap = new IndexMap(this.haps.nHaps() - 1);
        IndexMap indexMap2 = new IndexMap(this.haps.nHaps() - 1);
        int n2 = 0;
        this.matches(this.idSets, n, n2, indexMap);
        while (++n2 < this.idSets.length) {
            this.matches(this.idSets, n, n2, indexMap2);
            this.extend(indexMap, indexMap2);
            this.save(this.haps, n, indexMap, this.windowStarts[n2], arrayList);
            indexMap.clear();
            IndexMap indexMap3 = indexMap;
            indexMap = indexMap2;
            indexMap2 = indexMap3;
        }
        this.save(this.haps, n, indexMap, this.haps.nMarkers(), arrayList);
        return arrayList;
    }

    public List<HapSegment> filteredFind(int n) {
        ArrayList<HapSegment> arrayList = new ArrayList<HapSegment>(500);
        IndexMap indexMap = new IndexMap(this.haps.nHaps() - 1);
        IndexMap indexMap2 = new IndexMap(this.haps.nHaps() - 1);
        int n2 = 0;
        this.matches(this.idSets, n, n2, indexMap);
        while (++n2 < this.idSets.length) {
            this.matches(this.idSets, n, n2, indexMap2);
            int n3 = this.extend(indexMap, indexMap2);
            this.filteredSave(this.haps, n, indexMap, n3, this.windowStarts[n2], arrayList);
            indexMap.clear();
            IndexMap indexMap3 = indexMap;
            indexMap = indexMap2;
            indexMap2 = indexMap3;
        }
        this.filteredSave(this.haps, n, indexMap, n2, this.haps.nMarkers(), arrayList);
        return arrayList;
    }

    private void matches(int[][][] nArray, int n, int n2, IndexMap indexMap) {
        int[] nArray2;
        assert (indexMap.size() == 0);
        for (int n3 : nArray2 = nArray[n2][n]) {
            if (n3 == n) continue;
            indexMap.put(n3, n2);
        }
    }

    private int extend(IndexMap indexMap, IndexMap indexMap2) {
        int n = indexMap2.nil();
        int n2 = Integer.MAX_VALUE;
        int n3 = indexMap2.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = indexMap2.enumKey(i);
            int n5 = indexMap.get(n4);
            if (n5 == n) continue;
            indexMap2.put(n4, n5);
            indexMap.put(n4, -67);
            if (n5 >= n2) continue;
            n2 = n5;
        }
        return n2;
    }

    private void save(HapPairs hapPairs, int n, IndexMap indexMap, int n2, List<HapSegment> list) {
        int n3 = indexMap.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = indexMap.enumKey(i);
            int n5 = indexMap.enumValue(i);
            if (n5 == -67) continue;
            int n6 = this.start(hapPairs, n, n4, this.windowStarts[n5]);
            int n7 = this.inclusiveEnd(hapPairs, n, n4, n2);
            if (!(this.pos[n7] - this.pos[n6] >= this.minLength)) continue;
            list.add(new HapSegment(n4, n6, n7));
        }
    }

    private void filteredSave(HapPairs hapPairs, int n, IndexMap indexMap, int n2, int n3, List<HapSegment> list) {
        int n4 = indexMap.size();
        for (int i = 0; i < n4; ++i) {
            int n5 = indexMap.enumKey(i);
            int n6 = indexMap.enumValue(i);
            if (n6 == -67 || n6 > n2) continue;
            int n7 = this.start(hapPairs, n, n5, this.windowStarts[n6]);
            int n8 = this.inclusiveEnd(hapPairs, n, n5, n3);
            if (!(this.pos[n8] - this.pos[n7] >= this.minLength)) continue;
            list.add(new HapSegment(n5, n7, n8));
        }
    }

    private int start(HapPairs hapPairs, int n, int n2, int n3) {
        while (n3 > 0 && hapPairs.allele(n3 - 1, n) == hapPairs.allele(n3 - 1, n2)) {
            --n3;
        }
        return n3;
    }

    private int inclusiveEnd(HapPairs hapPairs, int n, int n2, int n3) {
        while (n3 < hapPairs.nMarkers() && hapPairs.allele(n3, n) == hapPairs.allele(n3, n2)) {
            ++n3;
        }
        return n3 - 1;
    }
}

