/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.HapPairs;
import java.util.HashMap;
import java.util.Map;
import main.NuclearFamilies;

public class Weights {
    private final NuclearFamilies fam;
    private final float nonRefWt;

    public Weights(NuclearFamilies nuclearFamilies) {
        this(nuclearFamilies, 1.0f);
    }

    public Weights(NuclearFamilies nuclearFamilies, float f) {
        if (nuclearFamilies == null) {
            throw new NullPointerException("fam==null");
        }
        if (f < 0.0f || f > 1.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("nonRefWeight: " + f);
        }
        this.fam = nuclearFamilies;
        this.nonRefWt = f;
    }

    public float[] get(HapPairs hapPairs) {
        Samples samples = this.families().samples();
        float[] fArray = new float[hapPairs.nHaps()];
        Map<Integer, Integer> map = Weights.cntMap(hapPairs);
        int n = 0;
        int n2 = hapPairs.nHapPairs();
        for (int i = 0; i < n2; ++i) {
            int n3 = hapPairs.idIndex(i);
            int n4 = samples.index(n3);
            int n5 = 0;
            if (n4 != -1) {
                if (this.families().father(n4) >= 0) {
                    ++n5;
                }
                if (this.families().mother(n4) >= 0) {
                    ++n5;
                }
            }
            float f = n4 == -1 ? 1.0f : this.nonRefWt();
            int n6 = map.get(n3);
            float f2 = f / (float)n6;
            float f3 = 0.01f;
            float f4 = f3 / (float)n6;
            fArray[n++] = n5 > 0 ? f4 : f2;
            fArray[n++] = n5 == 2 ? f4 : f2;
        }
        return fArray;
    }

    private static Map<Integer, Integer> cntMap(HapPairs hapPairs) {
        int n = hapPairs.nHapPairs();
        int n2 = 1 + (3 * n + 1) / 2;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n2);
        for (int i = 0; i < n; ++i) {
            int n3 = hapPairs.idIndex(i);
            Integer n4 = (Integer)hashMap.get(n3);
            if (n4 == null) {
                n4 = 0;
            }
            hashMap.put(n3, n4 + 1);
        }
        return hashMap;
    }

    public NuclearFamilies families() {
        return this.fam;
    }

    public float nonRefWt() {
        return this.nonRefWt;
    }
}

