% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_sex}
\alias{pin_sex}
\title{Calculate sex from \code{pin}}
\usage{
pin_sex(pin)
}
\arguments{
\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}
}
\value{
Factor with label 'Male' and 'Female'.
}
\description{
Calculates the sex from the personal identification number.
}
\examples{
# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "186408233224")
pin_sex(ex_pin)

}
\references{
\itemize{
 \item Skatteverket, \href{https://github.com/rOpenGov/sweidnumbr/blob/master/docs/skv717B-4.pdf}{\emph{Population registration in Sweden}}. SKV 717B. (2007)
 \item Skatteverket, \href{https://github.com/rOpenGov/sweidnumbr/blob/master/docs/skv704-8.pdf}{\emph{Personnummer}}. SKV 704. (2007)
 \href{http://www.riksdagen.se/sv/Dokument-Lagar/Utredningar/Statens-offentliga-utredningar/Personnummer-och-samordningsnu_GWB360/}{SOU 2008:60 : Personnummer och samordningsnummer}, (2008)
}
}
