% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swarm_space.R
\name{swarm_space}
\alias{swarm_space}
\title{Create a Swarm Space}
\usage{
swarm_space(
  metrics_data,
  space_type = "pca",
  event_dur_limit = NA,
  tsne_rand_seed = NA,
  tsne_perplexity = 25
)
}
\arguments{
\item{metrics_data}{A dataframe with metrics of collective motion per event.}

\item{space_type}{A string, stating the choice between PCA ("pca")
and t-SNE ("tsne"), default = "pca".}

\item{event_dur_limit}{Numeric, capturing an event duration value in seconds.
Used to filter out events that are shorter that this value.
Default = NA, no filtering is applied.}

\item{tsne_rand_seed}{Numeric, the random seed for the t-SNE analysis, to
ensure reproducibility. Default = NA, but a value should be given if the
t-SNE analysis is selected.}

\item{tsne_perplexity}{Numeric, the perplexity parameter for the t-SNE analysis.
Usually between 10-50, default = 25.}
}
\value{
A list with 3 elements: a dataframe representing the
swarm space (x and y coordinates per event of each species), a reference dataframe
(\code{ref}) including all the additional event information from the input metric data
dataframe, a dataframe for the t-SNE analysis (\code{tsne_setup}) that includes the
input parameters used, and a list for the PCA analysis (pca) with the output
of the \code{stats::prcomp} command.
}
\description{
This function runs a PCA (Principal component analysis)
or a t-SNE (t-distributed Stochastic Neighbor Embedding) over the
global and pairwise metrics of collective motion per each event to
produce a swarm space. The PCA is computed with the \code{stats::prcomp}
function and the t-SNE with the \code{Rtsne::Rtsne} function.
}
\examples{

data(multi_species_metrics)
ss <- swarm_space(multi_species_metrics)

}
\seealso{
\code{\link{group_metrics}, \link{pairwise_metrics}, \link{nn_metrics}, \link{col_motion_metrics}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
