\name{svyPVbenchmark}
\alias{svyPVbenchmark}


\title{
Estimate the proportion below and above a bechmark
}
\description{
This function works in a similar fashion like the \code{svyPVlevel} function. It discretizes the plausible values to a dichotomous variable and estimates the proportion of population totals above and below the benchmark within the comitted groups (by statement).
}
\usage{
svyPVbenchmark(by, svydat, pvs, BENCH=NA, colN=FALSE)
}


\arguments{
\item{by}{
A formula statement is expected which splits the data into several subsets.
}
  \item{svydat}{
A survey design (\code{svydesign} as well as \code{svrepdesign}) which was generated by the \code{survey} package. To figure out how to create a survey design object, please read the help files for the \code{survey} package.
}
  \item{pvs}{
A character vector which includes the colnames of the plausible values. These variables must be part of the survey design comitted as \code{svydat}.
}
  \item{BENCH}{
Submit a benchmark (numeric vector of length = 1). A plausible value will be assigned to "< benchmark" if it is below the benchmark and assigned to ">= benchmark" if it is on or above the benchmark.
}

  \item{colN}{
If TRUE the colnames will equal the grouping variable names from the by statement. If FALSE, which is the default, the names will be Group1 up to Group k.}

}

\value{
The function returns a data.frame with the following columns

\item{Group1..k}{The first k-1 columns show the different levels of the k-1 subsetting groups, provided with \code{by}. The kth group column contains the benchmark variable.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
\item{Proportion}{Contains the estimate of the conditional proportion of persons below and on/above the benchmark given the categories of the first k-1 groups.}
\item{Proportion.SE}{Contains the SE of the proportion estimate.}
}
\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}
\author{
Manuel Reif
}



\seealso{
\code{\link{svyPVlevel}}
}


\examples{

data(svy_example1)

erg_ben <- svyPVbenchmark(by = ~ sex, svydat=svy.exrep, 
pvs=c("plaus1","plaus2","plaus3"), BENCH=320)

erg_ben



}


\keyword{benchmark}

