% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcompetingrisks.R
\name{ggcompetingrisks}
\alias{ggcompetingrisks}
\title{Cumulative Incidence Curves for Competing Risks}
\usage{
ggcompetingrisks(fit, gnames = NULL, gsep = " ",
  multiple_panels = TRUE, ggtheme = theme_survminer(), coef = 1.96,
  conf.int = FALSE, ...)
}
\arguments{
\item{fit}{an object of a class \code{cmprsk::cuminc} - created with \code{cmprsk::cuminc} function or \code{survfitms} created with \link{survfit} function.}

\item{gnames}{a vector with group names. If not supplied then will be extracted from \code{fit} object (\code{cuminc} only).}

\item{gsep}{a separator that extracts group names and event names from \code{gnames} object (\code{cuminc} only).}

\item{multiple_panels}{if \code{TRUE} then groups will be plotted in different panels (\code{cuminc} only).}

\item{ggtheme}{function, \code{ggplot2} theme name. Default value is \link{theme_survminer}.
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}

\item{coef}{see \code{conf.int}, scaling actor for the ribbon. The default value is 1.96.}

\item{conf.int}{if \code{TRUE} then additional layer (\code{geom_ribbon}) is added around the point estimate. The ribon is plotted with boundries +- \code{coef}*standard deviation.}

\item{...}{further arguments passed to the function \code{\link[ggpubr]{ggpar}} for customizing the plot.}
}
\value{
Returns an object of class \code{gg}.
}
\description{
This function plots Cumulative Incidence Curves. For \code{cuminc} objects it's a \code{ggplot2} version of \code{plot.cuminc}.
For \code{survfitms} objects a different geometry is used, as suggested by \code{@teigentler}.
}
\examples{
\dontrun{
if(require("cmprsk")){

set.seed(2)
ss <- rexp(100)
gg <- factor(sample(1:3,100,replace=TRUE),1:3,c('BRCA','LUNG','OV'))
cc <- factor(sample(0:2,100,replace=TRUE),0:2,c('no event', 'death', 'progression'))
strt <- sample(1:2,100,replace=TRUE)

# handles cuminc objects
print(fit <- cmprsk::cuminc(ss,cc,gg,strt))
ggcompetingrisks(fit)
ggcompetingrisks(fit, multiple_panels = FALSE)
ggcompetingrisks(fit, conf.int = TRUE)
ggcompetingrisks(fit, multiple_panels = FALSE, conf.int = TRUE)

# handles survfitms objects
library(survival)
df <- data.frame(time = ss, group = gg, status = cc, strt)
fit2 <- survfit(Surv(time, status, type="mstate") ~ 1, data=df)
ggcompetingrisks(fit2)
fit3 <- survfit(Surv(time, status, type="mstate") ~ group, data=df)
ggcompetingrisks(fit3)
}

  library(ggsci)
  library(cowplot)
  ggcompetingrisks(fit3) + theme_cowplot() + scale_fill_jco()
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
