% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{jury_votes}
\alias{jury_votes}
\title{Jury votes}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{castaway}}{Name of the castaway}
  \item{\code{finalist}}{The finalists for which a vote can be placed}
  \item{\code{vote}}{Vote. 0-1 variable for easy summation}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
jury_votes
}
\description{
A dataset containing details on the final jury votes to determine the winner for each season
}
\examples{
library(dplyr)
jury_votes \%>\%
  filter(season == 40) \%>\%
  group_by(finalist) \%>\%
  summarise(votes = sum(vote))
}
\keyword{datasets}
