% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_60.r
\name{smooth.cons}
\alias{smooth.cons}
\title{Design and penalty matrices of penalized splines in a smooth.spec object}
\usage{
smooth.cons(
  term,
  knots,
  df,
  by = NULL,
  option,
  data.spec,
  same.rho = FALSE,
  name
)
}
\arguments{
\item{term}{Vector of strings that generally comes from the value "term" of a \code{smooth.spec} object.}

\item{knots}{List of numeric vectors that specifies the knots of the splines (including boundaries).}

\item{df}{Degrees of freedom: numeric vector that indicates the number of knots desired for each covariate.}

\item{by}{numeric or factor variable in order to define a varying coefficient smooth; default is NULL.}

\item{option}{"smf", "tensor" or "tint".}

\item{data.spec}{data frame that represents the environment from which the covariate values and knots are to be calculated; default is NULL.}

\item{same.rho}{if there is a factor by variable, should the smoothing parameters be the same for all levels; default is FALSE.}

\item{name}{simplified name of the smooth.spec call.}
}
\value{
List of objects with the following items:
\item{X}{Design matrix}
\item{pen}{List of penalty matrices}
\item{term}{Vector of strings giving the names of each covariate}
\item{knots}{list of numeric vectors that specifies the knots for each covariate}
\item{dim}{Number of covariates}
\item{all.df}{Numeric vector giving the number of knots associated with each covariate}
\item{sum.df}{Sum of all.df}
\item{Z.smf}{List of matrices that represents the sum-to-zero constraint to apply for "smf" splines}
\item{Z.tensor}{List of matrices that represents the sum-to-zero constraint to apply for "tensor" splines}
\item{Z.tint}{List of matrices that represents the sum-to-zero constraint to apply for "tint" splines}
\item{lambda.name}{name of the smoothing parameters}
}
\description{
Builds the design and penalty matrices from the result of \code{\link{smooth.spec}}.
}
\examples{

library(survPen)

# standard spline of time with 4 knots (so we get a design matrix with 3 columns 
# because of centering constraint)

data <- data.frame(time=seq(0,5,length=100))
smooth.c <- smooth.cons("time",knots=list(c(0,1,3,5)),df=4,option="smf",
data.spec=data,name="smf(time)")

}
