#' Functions to extract raw simulated samples
#'
#'
#' @rdname extractrawsim
#' @export
#' @param sim A `survparamsim` class object generated by \code{\link{surv_param_sim}} function.
#' @details
#' \code{\link{extract_sim}} extracts raw survival time & event status for all simulated subjects.
extract_sim <- function(sim) {

  time.var   <- as.character(attributes(stats::formula(sim$survreg))$variables[[2]][[2]])
  status.var <- as.character(attributes(stats::formula(sim$survreg))$variables[[2]][[3]])
  if(status.var[[1]] == "!") status.var <- status.var[[2]]


  if(methods::is(sim, "survparamsim_resample")){
    sim.merged.with.cov <-
      sim$newdata.nona.sim %>%
      dplyr::select(-time.var, -status.var, -n.resample) %>%
      dplyr::left_join(sim$sim, ., by = c("rep", "subj.sim")) %>%
      dplyr::select(rep, subj.sim, time, event, dplyr::everything())

  } else {
    sim.merged.with.cov <-
      sim$newdata.nona.sim %>%
      dplyr::select(-time.var, -status.var) %>%
      dplyr::left_join(sim$sim, ., by = c("subj.sim")) %>%
      dplyr::select(rep, subj.sim, time, event, dplyr::everything())
  }

  return(sim.merged.with.cov)
}


#' @rdname extractrawsim
#' @export
#' @param hr.pi a return object from \code{\link{calc_hr_pi}} function.
#' @details
#' \code{\link{extract_hr}} extracts simulated HRs for all repeated simulations
extract_hr <- function(hr.pi) {

  return(dplyr::select(hr.pi$sim.hr, -description))
}

