% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_values.R
\name{extract_values}
\alias{extract_values}
\title{Extract values around the sudden gain}
\usage{
extract_values(data, id_var_name, extract_var_list, extract_measure_name,
  start_numbering = 1, add_to_data = TRUE)
}
\arguments{
\item{data}{A \code{bysg} or \code{byperson} data set in wide format with the variable \code{sg_session_n} and all variables specified in \code{extract_var_list}.}

\item{id_var_name}{String, specifying the name of the ID variable.}

\item{extract_var_list}{Vector, specifying the variable names of session to session scores to extract from.
Note that this list has to have the same number of repeated measures as specified in \code{sg_var_list} when creating the sudden gains data set.}

\item{extract_measure_name}{String, specifying the name of the measure being used to extract values from.}

\item{start_numbering}{Numeric, set to by default 1.
Change to 0 if a pre-treatment (e.g. baseline assessment) measurement point is included in \code{extract_var_list}.}

\item{add_to_data}{Logical, if set to \code{TRUE}, the extracted values are added as new variables to the input dataset.
If set to false, only the ID variable and all extracted values will be returned.}
}
\value{
A wide dataset with values for \code{extract_measure_name} around the sudden gain.
}
\description{
Extract values of measures around the time of a sudden gain.
}
\examples{
# Create bysg dataset
bysg <- create_bysg(data = sgdata,
                    sg_crit1_cutoff = 7,
                    id_var_name = "id",
                    tx_start_var_name = "bdi_s1",
                    tx_end_var_name = "bdi_s12",
                    sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                                    "bdi_s4", "bdi_s5", "bdi_s6",
                                    "bdi_s7", "bdi_s8", "bdi_s9",
                                    "bdi_s10", "bdi_s11", "bdi_s12"),
                    sg_measure_name = "bdi")

# For bysg dataset select "id" and "rq" variables first
sgdata_rq <- sgdata \%>\%
  dplyr::select(id, rq_s0:rq_s12)

# Join them with the sudden gains data set, here "bysg"
bysg_rq <- bysg \%>\%
  dplyr::left_join(sgdata_rq, by = "id")

# Extract "rq" scores around sudden gains on "bdi" in the bysg dataset
bysg_rq <- extract_values(data = bysg_rq,
                          id_var_name = "id_sg",
                          extract_var_list = c("rq_s1", "rq_s2", "rq_s3", "rq_s4",
                                               "rq_s5", "rq_s6", "rq_s7", "rq_s8",
                                               "rq_s9", "rq_s10", "rq_s11", "rq_s12"),
                          extract_measure_name = "rq",
                          add_to_data = TRUE)
}
