/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropyBasedSplitCrit;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class InfoGainSplitCrit
extends EntropyBasedSplitCrit {
    private static final long serialVersionUID = 4892105020180728499L;

    @Override
    public final double splitCritValue(Distribution bags) {
        double numerator = this.oldEnt(bags) - this.newEnt(bags);
        if (Utils.eq(numerator, 0.0)) {
            return Double.MAX_VALUE;
        }
        return bags.total() / numerator;
    }

    public final double splitCritValue(Distribution bags, double totalNoInst) {
        double noUnknown = totalNoInst - bags.total();
        double unknownRate = noUnknown / totalNoInst;
        double numerator = this.oldEnt(bags) - this.newEnt(bags);
        if (Utils.eq(numerator = (1.0 - unknownRate) * numerator, 0.0)) {
            return 0.0;
        }
        return numerator / bags.total();
    }

    public final double splitCritValue(Distribution bags, double totalNoInst, double oldEnt) {
        double noUnknown = totalNoInst - bags.total();
        double unknownRate = noUnknown / totalNoInst;
        double numerator = oldEnt - this.newEnt(bags);
        if (Utils.eq(numerator = (1.0 - unknownRate) * numerator, 0.0)) {
            return 0.0;
        }
        return numerator / bags.total();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }
}

