#!/usr/bin/Rscript
# execute from: ./tests/dev/generate_roxygen_tests.R
roxygen_stub <- "roxygen-examples-complete"
all_examples <- list.files(file.path("tests", "testthat", roxygen_stub))
unique_tests <- unique(sub("-.*", "", all_examples))

# tests using 'scope = "spaces"' in test_collection()
tests_scope_spaces <- "15"

condition_map <- list(`23` = c("error", '"issues/1242"'))

for (test in unique_tests) {
  out_file <- file.path("tests", "testthat", paste0("test-", roxygen_stub, "-", test, ".R"))
  extras <- if (test %in% tests_scope_spaces) ', scope = "spaces"' else ""
  condition <- condition_map[[test]]
  if (is.null(condition)) condition <- c("warning", "NA")
  writeLines(con = out_file, c(
    "# NB: DO NOT EDIT. Auto-generated by ./tests/dev/generate_roxygen_tests.R.",
    "",
    sprintf('test_that("analogous to test-%s: %s", {', roxygen_stub, test),
    sprintf(
      '  expect_%s(test_collection("%s", "^%s-", transformer = style_text%s), %s)',
      condition[1L], roxygen_stub, test, extras, condition[2L]
    ),
    "})",
    NULL
  ))
}
