% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_load.R
\name{load_SL_tibble}
\alias{load_SL_tibble}
\title{load_SL_tibble}
\usage{
load_SL_tibble(schema, table, location = ".",
  time_options = c("interval", "timestamp", "dateonly", "dateless"),
  vars, csv_nrows, datafolder = "dataset",
  uid_range = getOption("SL_uids"))
}
\arguments{
\item{schema}{A character string. The menu 1 choice. Leave
blank to choose interactively.}

\item{table}{A character string. The menu 2 choice. Leave
blank to choose interactively.}

\item{location}{The path to a copy of the StudentLife dataset.}

\item{time_options}{A character vector specifying which
table types (out of "interval", "timestamp", "dateonly" and "dateless")
to include in the menu. This allows you to restrict menu options
according to the amount of date-time information present in the data.
The default includes all data. Note
this parameter only has an effect when used with the interactive menu.}

\item{vars}{Character vector of variable
names to import for all students. Leave
blank and this will be chosen interactively
if necesssary. If \code{vars} contains
"timestamp" then effort will be made
to convert "timestamp" to appropriate
variable name(s) for the target table.}

\item{csv_nrows}{An integer specifying the number of rows to read
per student if the target is a csv. The largest files in StudentLife are csv
files, so this allows code testing with less overhead.}

\item{datafolder}{Specifies the subfolder of \code{location}
that contains the relevant data. This should normally
be left as the default.}

\item{uid_range}{An integer vector. The range of uids in
the StudentLife study.}
}
\value{
An object of class \code{SL_tibble} is returned. These inherit
properties from class \code{\link[tibble]{tibble}} and
class \code{\link{data.frame}}.
Depending on the date-time information available, the object
may also be a \code{timestamp_SL_tibble},
\code{interval_SL_tibble} or
\code{dateonly_SL_tibble} (which are all
subclasses of \code{SL_tibble}).
}
\description{
Import a chosen StudentLife table as
a tibble. Leave \code{schema} and \code{table}
unspecified to choose interactively via a
menu.
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

\donttest{
## With menu
load_SL_tibble(location = d)
}

## Without menu
SL_tables
PAM <- load_SL_tibble(schema = "EMA", table = "PAM", location = d)

## Load less data for testing with less overhead
act <- load_SL_tibble(schema = "sensing", table = "activity",
                     location = d, csv_nrows = 10)

\donttest{
## Browse all tables with timestamps (non-interval)
load_SL_tibble(location = d, time_options = "timestamp")

## Browse all tables with intervals
load_SL_tibble(location = d, time_options = "interval")

## Browse all dateless tables
load_SL_tibble(location = d, time_options = "dateless")
}
}
