% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericModelingClasses.R
\docType{class}
\name{ContinModel}
\alias{ContinModel}
\title{R6 class for fitting and predicting joint probability for a univariate continuous summary A[j]}
\format{An \code{\link{R6Class}} generator object}
\usage{
ContinModel
}
\description{
This R6 class defines and fits a conditional probability model \code{P(A[j]|W,...)} for a univariate
 continuous summary measure \code{A[j]}. This class inherits from \code{\link{GenericModel}} class.
 Defines the fitting algorithm for a regression model \code{A[j] ~ W + ...}.
 Reconstructs the likelihood \code{P(A[j]=a[j]|W,...)} afterwards.
 Continuous \code{A[j]} is discretized using either of the 3 interval cutoff methods,
 defined via \code{\link{RegressionClass}} object \code{reg} passed to this class constructor.
 The fitting algorithm estimates the binary regressions for hazard \code{Bin_A[j][i] ~ W},
 i.e., the probability that continuous \code{A[j]} falls into bin \code{i}, \code{Bin_A[j]_i},
 given that \code{A[j]} does not belong to any prior bins \code{Bin_A[j]_1, ..., Bin_A[j]_{i-1}}.
 The dataset of discretized summary measures (\code{BinA[j]_1,...,BinA[j]_M}) is created
 inside the passed \code{data} or \code{newdata} object while discretizing \code{A[j]} into \code{M} bins.
}
\details{
\itemize{
\item{\code{reg}} - .
\item{\code{outvar}} - .
\item{\code{intrvls}} - .
\item{\code{intrvls.width}} - .
\item{\code{bin_weights}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg, DataStorageClass.g0, DataStorageClass.gstar, ...)}}{...}
  \item{\code{fit(data)}}{...}
  \item{\code{predict(newdata)}}{...}
  \item{\code{predictAeqa(newdata)}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{cats}}{...}
}
}
\keyword{R6}
\keyword{class}

