% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSOutlier_MCOD.R
\name{DSOutlier_MCOD}
\alias{DSOutlier_MCOD}
\alias{DSC_MCOD}
\alias{DSC_MCOD_MOA}
\alias{DSOutlier_MCOD_MOA}
\alias{MCOD}
\title{Micro-cluster Continuous Outlier Detector (MCOD)}
\usage{
DSOutlier_MCOD(r = 0.1, t = 50, w = 1000, recheck_outliers = TRUE)
}
\arguments{
\item{r}{Defines the micro-cluster radius}

\item{t}{Defines the number of neighbors (k in the article)}

\item{w}{Defines the window width in data points}

\item{recheck_outliers}{Defines that the MCOD algorithm allows re-checking
of detected outliers.}
}
\value{
An object of class \code{DSC_MCOD} (subclass of \code{DSOutlier},
\code{DSC_Micro}, \code{DSC_MOA} and \code{DSC}).
}
\description{
Class interfaces the MOA implementation of the MCOD algorithm for
distance-based data stream outlier detection.
}
\details{
The algorithm detects density-based outliers. An object \eqn{x} is defined
to be an outlier if there are less than \eqn{t} objects lying at distance at
most \eqn{r} from \eqn{x}.
}
\examples{
set.seed(1234)

# two-stage example
stream <- DSD_Gaussians(k = 3, d = 2,
            separation_type = "Mahalanobis", separation = 2,
            space_limit = c(0, 30), variance_limit = 0.8,
            outliers = 10,
            outlier_options = list(outlier_horizon = 200))

mic_c <- DSC_MCOD(r = 2, t = 10, w = 200)
mac_c <- DSC_Kmeans(3)
c <- DSC_TwoStage(mic_c, mac_c)

evaluate(c, stream, n = 200, type = "macro",
  measure = c("crand","outlierjaccard"))

reset_stream(stream)
plot(c, stream, n = 200, type = "all")
}
\references{
Kontaki M, Gounaris A, Papadopoulos AN, Tsichlas K, and
Manolopoulos Y (2016). Efficient and flexible algorithms for monitoring
distance-based outliers over data streams. Information systems, vol.
55, pp. 37-53. \doi{10.1109/ICDE.2011.5767923}
}
\seealso{
\code{\link{DSOutlier}}, \code{\link{DSC}},
\code{\link{DSC_Micro}}, \code{\link{DSC_MOA}}
}
\author{
Dalibor Krleža
}
