/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.SparseInstanceData;
import java.io.Serializable;
import java.util.ArrayList;
import weka.core.DenseInstance;
import weka.core.SparseInstance;

public class SamoaToWekaInstanceConverter
implements Serializable {
    protected weka.core.Instances wekaInstanceInformation;

    public weka.core.Instance wekaInstance(Instance inst) {
        DenseInstance wekaInstance;
        if (((InstanceImpl)inst).instanceData instanceof SparseInstanceData) {
            InstanceImpl instance = (InstanceImpl)inst;
            SparseInstanceData sparseInstanceData = (SparseInstanceData)instance.instanceData;
            wekaInstance = new SparseInstance(instance.weight(), sparseInstanceData.getAttributeValues(), sparseInstanceData.getIndexValues(), sparseInstanceData.getNumberAttributes());
        } else {
            Instance instance = inst;
            wekaInstance = new DenseInstance(instance.weight(), instance.toDoubleArray());
        }
        if (this.wekaInstanceInformation == null) {
            this.wekaInstanceInformation = this.wekaInstancesInformation(inst.dataset());
        }
        wekaInstance.setDataset(this.wekaInstanceInformation);
        if (inst.numOutputAttributes() == 1) {
            wekaInstance.setClassValue(inst.classValue());
        }
        return wekaInstance;
    }

    public weka.core.Instances wekaInstances(Instances instances) {
        weka.core.Instances wekaInstances;
        this.wekaInstanceInformation = wekaInstances = this.wekaInstancesInformation(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            wekaInstances.add(this.wekaInstance(instances.instance(i)));
        }
        return wekaInstances;
    }

    public weka.core.Instances wekaInstancesInformation(Instances instances) {
        ArrayList<weka.core.Attribute> attInfo = new ArrayList<weka.core.Attribute>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            attInfo.add(this.wekaAttribute(i, instances.attribute(i)));
        }
        weka.core.Instances wekaInstances = new weka.core.Instances(instances.getRelationName(), attInfo, 0);
        if (instances.instanceInformation.numOutputAttributes() == 1) {
            wekaInstances.setClassIndex(instances.classIndex());
        } else {
            wekaInstances.setClassIndex(instances.instanceInformation.numOutputAttributes() - 1);
        }
        return wekaInstances;
    }

    protected weka.core.Attribute wekaAttribute(int index, Attribute attribute) {
        weka.core.Attribute wekaAttribute = attribute.isNominal() ? new weka.core.Attribute(attribute.name(), attribute.getAttributeValues(), index) : new weka.core.Attribute(attribute.name(), index);
        return wekaAttribute;
    }
}

