/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.SimpleCOD;

import moa.clusterers.outliers.utils.mtree.DistanceFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamObj
implements DistanceFunctions.EuclideanCoordinate,
Comparable<StreamObj> {
    private final double[] values;
    private final int hashCode;

    public StreamObj(double ... values) {
        this.values = values;
        int h = 1;
        for (double value : values) {
            h = 31 * h + (int)value;
        }
        this.hashCode = h;
    }

    @Override
    public int dimensions() {
        return this.values.length;
    }

    @Override
    public double get(int index) {
        return this.values[index];
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamObj) {
            StreamObj that = (StreamObj)obj;
            if (this.dimensions() != that.dimensions()) {
                return false;
            }
            for (int i = 0; i < this.dimensions(); ++i) {
                if (this.values[i] == that.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(StreamObj that) {
        int dimensions = Math.min(this.dimensions(), that.dimensions());
        for (int i = 0; i < dimensions; ++i) {
            double v1 = this.values[i];
            double v2 = that.values[i];
            if (v1 > v2) {
                return 1;
            }
            if (!(v1 < v2)) continue;
            return -1;
        }
        if (this.dimensions() > dimensions) {
            return 1;
        }
        if (that.dimensions() > dimensions) {
            return -1;
        }
        return 0;
    }
}

