/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.DiscreteAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NullAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoeffdingOptionTree
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption maxOptionPathsOption = new IntOption("maxOptionPaths", 'o', "Maximum number of option paths per node.", 5, 1, Integer.MAX_VALUE);
    public IntOption maxByteSizeOption = new IntOption("maxByteSize", 'm', "Maximum memory consumed by the tree.", 0x2000000, 0, Integer.MAX_VALUE);
    public ClassOption numericEstimatorOption = new ClassOption("numericEstimator", 'n', "Numeric estimator to use.", NumericAttributeClassObserver.class, "GaussianNumericAttributeClassObserver");
    public ClassOption nominalEstimatorOption = new ClassOption("nominalEstimator", 'd', "Nominal estimator to use.", DiscreteAttributeClassObserver.class, "NominalAttributeClassObserver");
    public IntOption memoryEstimatePeriodOption = new IntOption("memoryEstimatePeriod", 'e', "How many instances between memory consumption checks.", 1000000, 0, Integer.MAX_VALUE);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SplitCriterion.class, "InfoGainSplitCriterion");
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption secondarySplitConfidenceOption = new FloatOption("secondarySplitConfidence", 'w', "The allowable error in secondary split decisions, values closer to 0 will take longer to decide.", 0.1, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FlagOption binarySplitsOption = new FlagOption("binarySplits", 'b', "Only allow binary splits.");
    public FlagOption removePoorAttsOption = new FlagOption("removePoorAtts", 'r', "Disable poor attributes.");
    public FlagOption noPrePruneOption = new FlagOption("noPrePrune", 'p', "Disable pre-pruning.");
    public FileOption dumpFileOption = new FileOption("dumpFile", 'f', "File to append option table to.", null, "csv", true);
    public IntOption memoryStrategyOption = new IntOption("memStrategy", 'z', "Memory strategy to use.", 2);
    protected Node treeRoot;
    protected int decisionNodeCount;
    protected int activeLeafNodeCount;
    protected int inactiveLeafNodeCount;
    protected double inactiveLeafByteSizeEstimate;
    protected double activeLeafByteSizeEstimate;
    protected double byteSizeEstimateOverheadFraction;
    protected int maxPredictionPaths;
    public MultiChoiceOption leafpredictionOption = new MultiChoiceOption("leafprediction", 'l', "Leaf prediction to use.", new String[]{"MC", "NB", "NBAdaptive"}, new String[]{"Majority class", "Naive Bayes", "Naive Bayes Adaptive"}, 2);
    public IntOption nbThresholdOption = new IntOption("nbThreshold", 'q', "The number of instances a leaf should observe before permitting Naive Bayes.", 0, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Hoeffding Option Tree: single tree that represents multiple trees.";
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSizeIncludingSubtree();
        }
        return size;
    }

    @Override
    public int measureByteSize() {
        return this.calcByteSize();
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.decisionNodeCount = 0;
        this.activeLeafNodeCount = 0;
        this.inactiveLeafNodeCount = 0;
        this.inactiveLeafByteSizeEstimate = 0.0;
        this.activeLeafByteSizeEstimate = 0.0;
        this.byteSizeEstimateOverheadFraction = 1.0;
        this.maxPredictionPaths = 0;
        if (this.leafpredictionOption.getChosenIndex() > 0) {
            this.removePoorAttsOption = null;
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        FoundNode[] foundNodes;
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            this.activeLeafNodeCount = 1;
        }
        for (FoundNode foundNode : foundNodes = this.treeRoot.filterInstanceToLeaves(inst, null, -1, true)) {
            ActiveLearningNode activeLearningNode;
            double weightSeen;
            Node leafNode = foundNode.node;
            if (leafNode == null) {
                leafNode = this.newLearningNode();
                foundNode.parent.setChild(foundNode.parentBranch, leafNode);
                ++this.activeLeafNodeCount;
            }
            if (!(leafNode instanceof LearningNode)) continue;
            LearningNode learningNode = (LearningNode)leafNode;
            learningNode.learnFromInstance(inst, this);
            if (!(learningNode instanceof ActiveLearningNode) || !((weightSeen = (activeLearningNode = (ActiveLearningNode)learningNode).getWeightSeen()) - activeLearningNode.getWeightSeenAtLastSplitEvaluation() >= (double)this.gracePeriodOption.getValue())) continue;
            this.attemptToSplit(activeLearningNode, foundNode.parent, foundNode.parentBranch);
            activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
        }
        if (this.trainingWeightSeenByModel % (double)this.memoryEstimatePeriodOption.getValue() == 0.0) {
            this.estimateModelByteSizes();
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot != null) {
            FoundNode[] foundNodes = this.treeRoot.filterInstanceToLeaves(inst, null, -1, false);
            DoubleVector result = new DoubleVector();
            int predictionPaths = 0;
            for (FoundNode foundNode : foundNodes) {
                if (foundNode.parentBranch == -999) continue;
                Node leafNode = foundNode.node;
                if (leafNode == null) {
                    leafNode = foundNode.parent;
                }
                double[] dist = leafNode.getClassVotes(inst, this);
                result.addValues(dist);
                ++predictionPaths;
            }
            if (predictionPaths > this.maxPredictionPaths) {
                ++this.maxPredictionPaths;
            }
            return result.getArrayRef();
        }
        return new double[0];
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (nodes)", this.decisionNodeCount + this.activeLeafNodeCount + this.inactiveLeafNodeCount), new Measurement("tree size (leaves)", this.activeLeafNodeCount + this.inactiveLeafNodeCount), new Measurement("active learning leaves", this.activeLeafNodeCount), new Measurement("tree depth", this.measureTreeDepth()), new Measurement("active leaf byte size estimate", this.activeLeafByteSizeEstimate), new Measurement("inactive leaf byte size estimate", this.inactiveLeafByteSizeEstimate), new Measurement("byte size estimate overhead", this.byteSizeEstimateOverheadFraction), new Measurement("maximum prediction paths used", this.maxPredictionPaths)};
    }

    public int measureTreeDepth() {
        if (this.treeRoot != null) {
            return this.treeRoot.subtreeDepth();
        }
        return 0;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        this.treeRoot.describeSubtree(this, out, indent);
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    protected AttributeClassObserver newNominalClassObserver() {
        AttributeClassObserver nominalClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.nominalEstimatorOption);
        return (AttributeClassObserver)nominalClassObserver.copy();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        AttributeClassObserver numericClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.numericEstimatorOption);
        return (AttributeClassObserver)numericClassObserver.copy();
    }

    protected void attemptToSplit(ActiveLearningNode node, SplitNode parent, int parentIndex) {
        if (!node.observedClassDistributionIsPure()) {
            Object bestSuggestion;
            double hoeffdingBound;
            SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
            Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
            Arrays.sort(bestSplitSuggestions);
            boolean shouldSplit = false;
            if (parentIndex != -999) {
                if (bestSplitSuggestions.length < 2) {
                    shouldSplit = bestSplitSuggestions.length > 0;
                } else {
                    hoeffdingBound = HoeffdingOptionTree.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.splitConfidenceOption.getValue(), node.getWeightSeen());
                    bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                    Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
                    if (((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)secondBestSuggestion).merit > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                        shouldSplit = true;
                    }
                    if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                        int[] splitAtts;
                        int i;
                        HashSet<Integer> poorAtts = new HashSet<Integer>();
                        for (i = 0; i < bestSplitSuggestions.length; ++i) {
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit > hoeffdingBound)) continue;
                            poorAtts.add(new Integer(splitAtts[0]));
                        }
                        for (i = 0; i < bestSplitSuggestions.length; ++i) {
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit < hoeffdingBound)) continue;
                            poorAtts.remove(new Integer(splitAtts[0]));
                        }
                        Iterator i$ = poorAtts.iterator();
                        while (i$.hasNext()) {
                            int poorAtt = (Integer)i$.next();
                            node.disableAttribute(poorAtt);
                        }
                    }
                }
            } else if (bestSplitSuggestions.length > 0) {
                hoeffdingBound = HoeffdingOptionTree.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.secondarySplitConfidenceOption.getValue(), node.getWeightSeen());
                bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                SplitNode current = parent;
                double bestPreviousMerit = Double.NEGATIVE_INFINITY;
                double[] preDist = node.getObservedClassDistribution();
                while (true) {
                    double merit;
                    if ((merit = current.computeMeritOfExistingSplit(splitCriterion, preDist)) > bestPreviousMerit) {
                        bestPreviousMerit = merit;
                    }
                    if (current.optionCount != -999) break;
                    current = current.parent;
                }
                if (((AttributeSplitSuggestion)bestSuggestion).merit - bestPreviousMerit > hoeffdingBound) {
                    shouldSplit = true;
                }
            }
            if (shouldSplit) {
                Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                    if (parentIndex != -999) {
                        this.deactivateLearningNode(node, parent, parentIndex);
                    }
                } else {
                    SplitNode newSplit = new SplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution());
                    newSplit.parent = parent;
                    SplitNode optionHead = parent;
                    if (parent != null) {
                        while (optionHead.optionCount == -999) {
                            optionHead = optionHead.parent;
                        }
                    }
                    if (parentIndex == -999 && parent != null) {
                        newSplit.optionCount = -999;
                        optionHead.updateOptionCountBelow(1, this);
                        if (optionHead.parent != null) {
                            optionHead.parent.updateOptionCount(optionHead, this);
                        }
                        this.addToOptionTable((AttributeSplitSuggestion)splitDecision, optionHead.parent);
                    } else {
                        newSplit.optionCount = optionHead == null ? 1 : optionHead.optionCount;
                    }
                    int numOptions = 1;
                    if (optionHead != null) {
                        numOptions = optionHead.optionCount;
                    }
                    if (numOptions < this.maxOptionPathsOption.getValue()) {
                        int[] splitAtts;
                        newSplit.nextOption = node;
                        for (int i : splitAtts = ((AttributeSplitSuggestion)splitDecision).splitTest.getAttsTestDependsOn()) {
                            node.disableAttribute(i);
                        }
                    } else {
                        --this.activeLeafNodeCount;
                    }
                    for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                        LearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                        newSplit.setChild(i, newChild);
                    }
                    ++this.decisionNodeCount;
                    this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                    if (parent == null) {
                        this.treeRoot = newSplit;
                    } else if (parentIndex != -999) {
                        parent.setChild(parentIndex, newSplit);
                    } else {
                        parent.nextOption = newSplit;
                    }
                }
                this.enforceTrackerLimit();
            }
        }
    }

    private void addToOptionTable(AttributeSplitSuggestion bestSuggestion, SplitNode parent) {
        File dumpFile = this.dumpFileOption.getFile();
        PrintStream immediateResultStream = null;
        if (dumpFile != null) {
            try {
                immediateResultStream = dumpFile.exists() ? new PrintStream(new FileOutputStream(dumpFile, true), true) : new PrintStream(new FileOutputStream(dumpFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open dump file: " + dumpFile, ex);
            }
            int splitAtt = bestSuggestion.splitTest.getAttsTestDependsOn()[0];
            double splitVal = -1.0;
            if (bestSuggestion.splitTest instanceof NumericAttributeBinaryTest) {
                NumericAttributeBinaryTest test = (NumericAttributeBinaryTest)bestSuggestion.splitTest;
                splitVal = test.getSplitValue();
            }
            int treeDepth = 0;
            while (parent != null) {
                parent = parent.parent;
                ++treeDepth;
            }
            immediateResultStream.println(this.trainingWeightSeenByModel + "," + treeDepth + "," + splitAtt + "," + splitVal);
            immediateResultStream.flush();
            immediateResultStream.close();
        }
    }

    public void enforceTrackerLimit() {
        if (this.inactiveLeafNodeCount > 0 || ((double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue()) {
            int i;
            FoundNode[] learningNodes = this.findLearningNodes();
            Arrays.sort(learningNodes, new Comparator<FoundNode>(){

                @Override
                public int compare(FoundNode fn1, FoundNode fn2) {
                    if (HoeffdingOptionTree.this.memoryStrategyOption.getValue() == 0) {
                        return Double.compare(fn1.node.calculatePromise(), fn2.node.calculatePromise());
                    }
                    if (HoeffdingOptionTree.this.memoryStrategyOption.getValue() == 1) {
                        double p1 = fn1.node.calculatePromise();
                        if (fn1.parentBranch == -999) {
                            p1 /= (double)fn1.parent.getHeadOptionCount();
                        }
                        double p2 = fn2.node.calculatePromise();
                        if (fn2.parentBranch == -999) {
                            p1 /= (double)fn2.parent.getHeadOptionCount();
                        }
                        return Double.compare(p1, p2);
                    }
                    if (fn1.parentBranch == -999) {
                        if (fn2.parentBranch == -999) {
                            return Double.compare(fn1.node.calculatePromise(), fn2.node.calculatePromise());
                        }
                        return -1;
                    }
                    if (fn2.parentBranch == -999) {
                        return 1;
                    }
                    return Double.compare(fn1.node.calculatePromise(), fn2.node.calculatePromise());
                }
            });
            int maxActive = 0;
            while (maxActive < learningNodes.length) {
                if (!(((double)(++maxActive) * this.activeLeafByteSizeEstimate + (double)(learningNodes.length - maxActive) * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue())) continue;
                --maxActive;
                break;
            }
            int cutoff = learningNodes.length - maxActive;
            for (i = 0; i < cutoff; ++i) {
                if (!(learningNodes[i].node instanceof ActiveLearningNode)) continue;
                this.deactivateLearningNode((ActiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
            for (i = cutoff; i < learningNodes.length; ++i) {
                if (!(learningNodes[i].node instanceof InactiveLearningNode)) continue;
                this.activateLearningNode((InactiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
        }
    }

    public void estimateModelByteSizes() {
        FoundNode[] learningNodes = this.findLearningNodes();
        long totalActiveSize = 0L;
        long totalInactiveSize = 0L;
        for (FoundNode foundNode : learningNodes) {
            if (foundNode.node instanceof ActiveLearningNode) {
                totalActiveSize += SizeOf.fullSizeOf(foundNode.node);
                continue;
            }
            totalInactiveSize += SizeOf.fullSizeOf(foundNode.node);
        }
        if (totalActiveSize > 0L) {
            this.activeLeafByteSizeEstimate = (double)totalActiveSize / (double)this.activeLeafNodeCount;
        }
        if (totalInactiveSize > 0L) {
            this.inactiveLeafByteSizeEstimate = (double)totalInactiveSize / (double)this.inactiveLeafNodeCount;
        }
        int actualModelSize = this.measureByteSize();
        double estimatedModelSize = (double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate;
        this.byteSizeEstimateOverheadFraction = (double)actualModelSize / estimatedModelSize;
        if (actualModelSize > this.maxByteSizeOption.getValue()) {
            this.enforceTrackerLimit();
        }
    }

    public void deactivateAllLeaves() {
        FoundNode[] learningNodes = this.findLearningNodes();
        for (int i = 0; i < learningNodes.length; ++i) {
            if (!(learningNodes[i].node instanceof ActiveLearningNode)) continue;
            this.deactivateLearningNode((ActiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
        }
    }

    protected void deactivateLearningNode(ActiveLearningNode toDeactivate, SplitNode parent, int parentBranch) {
        InactiveLearningNode newLeaf = new InactiveLearningNode(toDeactivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else if (parentBranch != -999) {
            parent.setChild(parentBranch, newLeaf);
        } else {
            parent.nextOption = newLeaf;
        }
        --this.activeLeafNodeCount;
        ++this.inactiveLeafNodeCount;
    }

    protected void activateLearningNode(InactiveLearningNode toActivate, SplitNode parent, int parentBranch) {
        LearningNode newLeaf = this.newLearningNode(toActivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else if (parentBranch != -999) {
            parent.setChild(parentBranch, newLeaf);
        } else {
            parent.nextOption = newLeaf;
        }
        ++this.activeLeafNodeCount;
        --this.inactiveLeafNodeCount;
    }

    protected FoundNode[] findLearningNodes() {
        LinkedList<FoundNode> foundList = new LinkedList<FoundNode>();
        this.findLearningNodes(this.treeRoot, null, -1, foundList);
        return foundList.toArray(new FoundNode[foundList.size()]);
    }

    protected void findLearningNodes(Node node, SplitNode parent, int parentBranch, List<FoundNode> found) {
        if (node != null) {
            if (node instanceof LearningNode) {
                found.add(new FoundNode(node, parent, parentBranch));
            }
            if (node instanceof SplitNode) {
                SplitNode splitNode = (SplitNode)node;
                for (int i = 0; i < splitNode.numChildren(); ++i) {
                    this.findLearningNodes(splitNode.getChild(i), splitNode, i, found);
                }
                this.findLearningNodes(splitNode.nextOption, splitNode, -999, found);
            }
        }
    }

    protected LearningNode newLearningNode() {
        return this.newLearningNode(new double[0]);
    }

    protected LearningNode newLearningNode(double[] initialClassObservations) {
        int predictionOption = this.leafpredictionOption.getChosenIndex();
        ActiveLearningNode ret = predictionOption == 0 ? new ActiveLearningNode(initialClassObservations) : (predictionOption == 1 ? new LearningNodeNB(initialClassObservations) : new LearningNodeNBAdaptive(initialClassObservations));
        return ret;
    }

    public static class LearningNodeNBAdaptive
    extends LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingOptionTree hot) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex(NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, hot);
        }

        public double[] getClassVotes(Instance inst, HoeffdingOptionTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
        }
    }

    public static class LearningNodeNB
    extends ActiveLearningNode {
        private static final long serialVersionUID = 1L;

        public LearningNodeNB(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public double[] getClassVotes(Instance inst, HoeffdingOptionTree hot) {
            if (this.getWeightSeen() >= (double)hot.nbThresholdOption.getValue()) {
                return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            }
            return super.getClassVotes(inst, hot);
        }

        public void disableAttribute(int attIndex) {
        }
    }

    public static class ActiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        protected AutoExpandVector<AttributeClassObserver> attributeObservers = new AutoExpandVector();

        public ActiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
            this.weightSeenAtLastSplitEvaluation = this.getWeightSeen();
        }

        public int calcByteSize() {
            return super.calcByteSize() + (int)SizeOf.fullSizeOf(this.attributeObservers);
        }

        public void learnFromInstance(Instance inst, HoeffdingOptionTree ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = HoeffdingOptionTree.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }

        public double getWeightSeen() {
            return this.observedClassDistribution.sumOfValues();
        }

        public double getWeightSeenAtLastSplitEvaluation() {
            return this.weightSeenAtLastSplitEvaluation;
        }

        public void setWeightSeenAtLastSplitEvaluation(double weight) {
            this.weightSeenAtLastSplitEvaluation = weight;
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, HoeffdingOptionTree ht) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
            if (!ht.noPrePruneOption.isSet()) {
                bestSuggestions.add(new AttributeSplitSuggestion(null, new double[0][], criterion.getMeritOfSplit(preSplitDist, new double[][]{preSplitDist})));
            }
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeSplitSuggestion bestSuggestion;
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null || (bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitDist, i, ht.binarySplitsOption.isSet())) == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public void disableAttribute(int attIndex) {
            this.attributeObservers.set(attIndex, new NullAttributeClassObserver());
        }
    }

    public static class InactiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;

        public InactiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingOptionTree ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
        }
    }

    public static abstract class LearningNode
    extends Node {
        private static final long serialVersionUID = 1L;

        public LearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public abstract void learnFromInstance(Instance var1, HoeffdingOptionTree var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;
        protected SplitNode parent;
        protected Node nextOption;
        protected int optionCount;
        protected AutoExpandVector<Node> children = new AutoExpandVector();

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)(SizeOf.sizeOf(this.children) + SizeOf.fullSizeOf(this.splitTest));
        }

        @Override
        public int calcByteSizeIncludingSubtree() {
            int byteSize = this.calcByteSize();
            for (Node child : this.children) {
                if (child == null) continue;
                byteSize += child.calcByteSizeIncludingSubtree();
            }
            if (this.nextOption != null) {
                byteSize += this.nextOption.calcByteSizeIncludingSubtree();
            }
            return byteSize;
        }

        public SplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(classObservations);
            this.splitTest = splitTest;
        }

        public int numChildren() {
            return this.children.size();
        }

        public void setChild(int index, Node child) {
            if (this.splitTest.maxBranches() >= 0 && index >= this.splitTest.maxBranches()) {
                throw new IndexOutOfBoundsException();
            }
            this.children.set(index, child);
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void filterInstanceToLeaves(Instance inst, SplitNode myparent, int parentBranch, List<FoundNode> foundNodes, boolean updateSplitterCounts) {
            int childIndex;
            if (updateSplitterCounts) {
                this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            }
            if ((childIndex = this.instanceChildIndex(inst)) >= 0) {
                Node child = this.getChild(childIndex);
                if (child != null) {
                    child.filterInstanceToLeaves(inst, this, childIndex, foundNodes, updateSplitterCounts);
                } else {
                    foundNodes.add(new FoundNode(null, this, childIndex));
                }
            }
            if (this.nextOption != null) {
                this.nextOption.filterInstanceToLeaves(inst, this, -999, foundNodes, updateSplitterCounts);
            }
        }

        @Override
        public void describeSubtree(HoeffdingOptionTree ht, StringBuilder out, int indent) {
            for (int branch = 0; branch < this.numChildren(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                StringUtils.appendIndented(out, indent, "if ");
                out.append(this.splitTest.describeConditionForBranch(branch, ht.getModelContext()));
                out.append(": ");
                out.append("** option count = " + this.optionCount);
                StringUtils.appendNewline(out);
                child.describeSubtree(ht, out, indent + 2);
            }
        }

        @Override
        public int subtreeDepth() {
            int maxChildDepth = 0;
            for (Node child : this.children) {
                int depth;
                if (child == null || (depth = child.subtreeDepth()) <= maxChildDepth) continue;
                maxChildDepth = depth;
            }
            return maxChildDepth + 1;
        }

        public double computeMeritOfExistingSplit(SplitCriterion splitCriterion, double[] preDist) {
            double[][] postDists = new double[this.children.size()][];
            for (int i = 0; i < this.children.size(); ++i) {
                postDists[i] = this.children.get(i).getObservedClassDistribution();
            }
            return splitCriterion.getMeritOfSplit(preDist, postDists);
        }

        public void updateOptionCount(SplitNode source, HoeffdingOptionTree hot) {
            if (this.optionCount == -999) {
                this.parent.updateOptionCount(source, hot);
            } else {
                int maxChildCount = -999;
                SplitNode curr = this;
                while (curr != null) {
                    for (Node child : curr.children) {
                        if (!(child instanceof SplitNode)) continue;
                        SplitNode splitChild = (SplitNode)child;
                        if (splitChild.optionCount <= maxChildCount) continue;
                        maxChildCount = splitChild.optionCount;
                    }
                    if (curr.nextOption != null && curr.nextOption instanceof SplitNode) {
                        curr = (SplitNode)curr.nextOption;
                        continue;
                    }
                    curr = null;
                }
                if (maxChildCount > this.optionCount) {
                    int delta = maxChildCount - this.optionCount;
                    this.optionCount = maxChildCount;
                    if (this.optionCount >= hot.maxOptionPathsOption.getValue()) {
                        this.killOptionLeaf(hot);
                    }
                    curr = this;
                    while (curr != null) {
                        for (Node child : curr.children) {
                            SplitNode splitChild;
                            if (!(child instanceof SplitNode) || (splitChild = (SplitNode)child) == source) continue;
                            splitChild.updateOptionCountBelow(delta, hot);
                        }
                        if (curr.nextOption != null && curr.nextOption instanceof SplitNode) {
                            curr = (SplitNode)curr.nextOption;
                            continue;
                        }
                        curr = null;
                    }
                    if (this.parent != null) {
                        this.parent.updateOptionCount(this, hot);
                    }
                }
            }
        }

        public void updateOptionCountBelow(int delta, HoeffdingOptionTree hot) {
            if (this.optionCount != -999) {
                this.optionCount += delta;
                if (this.optionCount >= hot.maxOptionPathsOption.getValue()) {
                    this.killOptionLeaf(hot);
                }
            }
            for (Node child : this.children) {
                if (!(child instanceof SplitNode)) continue;
                SplitNode splitChild = (SplitNode)child;
                splitChild.updateOptionCountBelow(delta, hot);
            }
            if (this.nextOption instanceof SplitNode) {
                ((SplitNode)this.nextOption).updateOptionCountBelow(delta, hot);
            }
        }

        private void killOptionLeaf(HoeffdingOptionTree hot) {
            if (this.nextOption instanceof SplitNode) {
                ((SplitNode)this.nextOption).killOptionLeaf(hot);
            } else if (this.nextOption instanceof ActiveLearningNode) {
                this.nextOption = null;
                --hot.activeLeafNodeCount;
            } else if (this.nextOption instanceof InactiveLearningNode) {
                this.nextOption = null;
                --hot.inactiveLeafNodeCount;
            }
        }

        public int getHeadOptionCount() {
            SplitNode sn = this;
            while (sn.optionCount == -999) {
                sn = sn.parent;
            }
            return sn.optionCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        protected DoubleVector observedClassDistribution;

        public Node(double[] classObservations) {
            this.observedClassDistribution = new DoubleVector(classObservations);
        }

        public int calcByteSize() {
            return (int)(SizeOf.sizeOf(this) + SizeOf.fullSizeOf(this.observedClassDistribution));
        }

        public int calcByteSizeIncludingSubtree() {
            return this.calcByteSize();
        }

        public boolean isLeaf() {
            return true;
        }

        public FoundNode[] filterInstanceToLeaves(Instance inst, SplitNode parent, int parentBranch, boolean updateSplitterCounts) {
            LinkedList<FoundNode> nodes = new LinkedList<FoundNode>();
            this.filterInstanceToLeaves(inst, parent, parentBranch, nodes, updateSplitterCounts);
            return nodes.toArray(new FoundNode[nodes.size()]);
        }

        public void filterInstanceToLeaves(Instance inst, SplitNode splitparent, int parentBranch, List<FoundNode> foundNodes, boolean updateSplitterCounts) {
            foundNodes.add(new FoundNode(this, splitparent, parentBranch));
        }

        public double[] getObservedClassDistribution() {
            return this.observedClassDistribution.getArrayCopy();
        }

        public double[] getClassVotes(Instance inst, HoeffdingOptionTree ht) {
            double[] dist = this.observedClassDistribution.getArrayCopy();
            double distSum = Utils.sum(dist);
            if (distSum > 0.0) {
                Utils.normalize(dist, distSum);
            }
            return dist;
        }

        public boolean observedClassDistributionIsPure() {
            return this.observedClassDistribution.numNonZeroEntries() < 2;
        }

        public void describeSubtree(HoeffdingOptionTree ht, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            out.append(ht.getClassNameString());
            out.append(" = ");
            out.append(ht.getClassLabelString(this.observedClassDistribution.maxIndex()));
            out.append(" weights: ");
            this.observedClassDistribution.getSingleLineDescription(out, ht.treeRoot.observedClassDistribution.numValues());
            StringUtils.appendNewline(out);
        }

        public int subtreeDepth() {
            return 0;
        }

        public double calculatePromise() {
            double totalSeen = this.observedClassDistribution.sumOfValues();
            return totalSeen > 0.0 ? totalSeen - this.observedClassDistribution.getValue(this.observedClassDistribution.maxIndex()) : 0.0;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
            this.describeSubtree(null, sb, indent);
        }
    }

    public static class FoundNode {
        public Node node;
        public SplitNode parent;
        public int parentBranch;

        public FoundNode(Node node, SplitNode parent, int parentBranch) {
            this.node = node;
            this.parent = parent;
            this.parentBranch = parentBranch;
        }
    }
}

