% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_ReadWebService.R
\name{DSD_ReadWebService}
\alias{DSD_ReadWebService}
\title{A DSD That Reads for a Web Service}
\usage{
DSD_ReadWebService(url)
}
\arguments{
\item{url}{endpoint URI address in the format \verb{http://host:port/<optional_path>}.}
}
\value{
A \link[stream:DSD]{stream::DSD} object.
}
\description{
Reads from a web service that published an operation called
\code{get_points} which takes a parameter \code{n} and returns \code{n} data points in CSV or json
format.
}
\examples{
# find a free port
port <- httpuv::randomPort()
port

# create a background DSD process sending data to the port
rp1 <- publish_DSD_via_WebService("DSD_Gaussians(k = 3, d = 3)", port = port)

## use json for the transport layer instead of csv
# rp1 <- publish_DSD_via_WebService("DSD_Gaussians(k = 3, d = 3)", 
#              port = port, serialize = "json")
rp1

# create a DSD that connects to the web service
dsd <- DSD_ReadWebService(paste0("http://localhost:", port))
dsd

get_points(dsd, n = 10)

plot(dsd)

# end the DSD process. Note: that closing the connection above
# may already kill the process.
rp1$kill()
rp1
}
\seealso{
Other WebService: 
\code{\link{DSC_WebService}()},
\code{\link{publish_DSC_via_WebService}()},
\code{\link{publish_DSD_via_WebService}()}

Other dsd: 
\code{\link{DSD_ReadSocket}()},
\code{\link{publish_DSD_via_Socket}()},
\code{\link{publish_DSD_via_WebService}()}
}
\concept{WebService}
\concept{dsd}
