% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{var_st}
\alias{var_st}
\alias{var_st_tsi}
\title{Variance of the Stratified Estimator}
\usage{
var_st(x, a, a0)

var_st_tsi(x, N, S)
}
\arguments{
\item{x}{(\code{numeric})\cr sample allocations \eqn{x_1,\ldots,x_H} in strata.}

\item{a}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}.}

\item{a0}{(\code{number})\cr population constant \eqn{A_0}.}

\item{N}{(\code{numeric})\cr strata sizes \eqn{N_1,\ldots,N_H}.}

\item{S}{(\code{numeric})\cr strata standard deviations of a given study variable
\eqn{S_1,\ldots,S_H}.}
}
\value{
Value of the variance \eqn{V} for a given allocation vector
\eqn{x_1,\ldots,x_H}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Compute the value of the variance function \eqn{V} of the stratified
estimator, which is of the following generic form:
\deqn{V(x_1,\ldots,x_H) = \sum_{h=1}^H \frac{A^2_h}{x_h} - A_0,}
where \eqn{H} denotes total number of strata, \eqn{x_1,\ldots,x_H} are strata
sample sizes and \eqn{A_0,\, A_h > 0,\, h = 1,\ldots,H}, are population
constants.
}
\section{Functions}{
\itemize{
\item \code{var_st_tsi()}: computes value of variance \eqn{V} for the case of
\emph{stratified \eqn{\pi} estimator} of the population total and
\emph{stratified simple random sampling without replacement} design. This
particular case yields:
\deqn{A_h = N_h S_h, \quad h = 1,\ldots,H,}
\deqn{A_0 = \sum_{h=1}^H N_h S_h^2,}
where \eqn{N_h} is the size of stratum \eqn{h}, and \eqn{S_h} is stratum
standard deviation of a study variable, \eqn{h = 1,\ldots,H}.

}}
\examples{
N <- c(3000, 4000, 5000, 2000)
S <- rep(1, 4)
M <- c(100, 90, 70, 80)
opt <- opt(n = 190, a = N * S, M = M)
var_st_tsi(x = opt, N, S) # 1017579
}
\references{
Särndal, C.-E., Swensson, B. and Wretman, J. (1992).
\emph{Model Assisted Survey Sampling},
Chapter 3.7 \emph{Stratified Sampling},
Springer, New York.
}
