% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{sim.ci.median2}
\alias{sim.ci.median2}
\title{Simulates confidence interval coverage probability for a median difference
in a 2-group design}
\usage{
sim.ci.median2(alpha, n1, n2, sd.ratio, dist1, dist2, rep)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}

\item{sd.ratio}{ratio of population standard deviations (sd2/sd1)}

\item{dist1}{type of distribution for group 1 (1, 2, 3, 4, or 5)}

\item{dist2}{type of distribution for group 2 (1, 2, 3, 4, or 5)
\itemize{
\item 1 = Gaussian (skewness = 0 and excess kurtosis = 0)
\item 2 = platykurtic (skewness = 0 and excess kurtosis = -1.2)
\item 3 = leptokurtic (skewness = 0 and excess kurtosis = 6)
\item 4 = moderate skew (skewness = 1 and excess kurtosis = 1.5)
\item 5 = large skew (skewness = 2 and excess kurtosis = 6)
}}

\item{rep}{number of Monte Carlo samples}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Coverage - Probability of confidence interval including population median difference
\item Lower Error - Probability of lower limit greater than population median difference
\item Upper Error - Probability of upper limit less than population median difference
\item Ave CI Width - Average confidence interval width
}
}
\description{
Performs a computer simulation of the confidence interval performance for a
difference of population medians in a 2-group design. Sample data for each
group can be generated from five different population distributions. All
distributions are scaled to have standard deviations of 1.0 in group 1.
}
\examples{
sim.ci.median2(.05, 20, 20, 2, 5, 4, 5000)

# Should return (within sampling error):
# Coverage Lower Error Upper Error Ave CI Width
#    0.952       0.027       0.021     2.368914


}
