% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cronbach2}
\alias{ci.cronbach2}
\title{Confidence interval for a difference in Cronbach reliabilities in a 2-group
design}
\usage{
ci.cronbach2(alpha, rel1, rel2, r1, r2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{rel1}{estimated Cronbach reliablity for group 1}

\item{rel2}{estimated Cronbach reliablity for group 2}

\item{r1}{number of measurements used in group 1}

\item{r2}{number of measurements used in group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated reliability difference
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference in population Cronbach
reliability coefficicents in a 2-group design. The number of measurements
(e.g., items or raters) used in each group need not be equal.
}
\examples{
ci.cronbach2(.05, .88, .76, 8, 8, 200, 250)

# Should return:
#      Estimate         LL       UL
# [1,]     0.12 0.06973411 0.173236
 

}
\references{
\insertRef{Bonett2015}{statpsych}
}
