% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.agree}
\alias{ci.agree}
\title{Confidence interval for a G-index of agreement}
\usage{
ci.agree(alpha, n, f, k)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{sample size}

\item{f}{number of objects rated in agreement}

\item{k}{number of rating categories}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - maximum likelihood estimate of G-index
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a G-index of agreement between two
polychotomous ratings. This function requires the number of objects that
were given the same rating by both raters.
}
\examples{
ci.agree(.05, 100, 80, 4)

# Should return:
#       Estimate         SE        LL        UL
# [1,] 0.7333333 0.05333333 0.6132949 0.8226025


}
\references{
\insertRef{Bonett2022}{statpsych}
}
