% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.indirect}
\alias{ci.indirect}
\title{Confidence interval for an indirect effect}
\usage{
ci.indirect(alpha, b1, b2, se1, se2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{b1}{unstandardized slope estimate for first path}

\item{b2}{unstandardized slope estimate for second path}

\item{se1}{standard error for b1}

\item{se2}{standard error for b2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated indirect effect
\item SE - standard error of indirect effect
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Monte Carlo confidence interval (500,000 trials) for a population
unstandardized indirect effect in a path model. This function is not
recommended for a standardized indirect effect unless the standardized
slope estimates for both paths are less than about .3 in absolute value.
The Monte Carlo method is general in that the slope estimates and standard
errors do not need to be OLS estimates with homoscedastic standard errors.
For example, LAD slope estimates and their standard errors, OLS slope
estimates and heteroscedastic standard errors, distribution-free
Theil-Sen slope estimates with McKean-Schrader standard errors, or
standardized slopes with robust standard errors also could be used.
}
\examples{
ci.indirect (.05, 2.48, 1.92, .586, .379)

# Should return (within sampling error):
#      Estimate       SE       LL       UL
# [1,]   4.7616 1.625282 2.178812 7.972262
 

}
