% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.mean.ps}
\alias{size.ci.mean.ps}
\title{Sample size for a paired-samples mean difference confidence interval}
\usage{
size.ci.mean.ps(alpha, var, cor, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average variance of the two measurements}

\item{cor}{planning value of correlation between measurements}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a difference in population
means with desired confidence interval precision in a paired-samples
design. This function requires a planning value for the average of the
variances for the two measurements. Set the correlation planning value to
the smallest value within a plausible range for a conservatively large
sample size. Set the variance planning value to the largest value within
a plausible range for a conservatively large sample size.
}
\examples{
size.ci.mean.ps(.05, 265, .8, 10)

# Should return:
#      Sample size
# [1,]          19
 

}
