% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSYL.R
\name{SSYL}
\alias{SSYL}
\alias{YL.fun}
\alias{NLS.YL}
\alias{DRC.YL}
\title{Yield loss equation (Rectangular hyperbola)}
\usage{
YL.fun(predictor, i, A)
NLS.YL(predictor, i, A)
DRC.YL(fixed = c(NA, NA), names = c("i", "A"))
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{i}{model parameter (initial slope)}

\item{A}{model parameter (maximum percentage yield loss)}

\item{fixed}{numeric vector. Specifies which parameters are fixed and at what value they are fixed. NAs for parameter that are not fixed.}

\item{names}{a vector of character strings giving the names of the parameters. The default is usually reasonable.}
}
\value{
YL.fun and NLS.YL return a numeric value, while DRC.YL returns
a list containing the nonlinear function and the self starter function
}
\description{
These functions provide the yield loss equation, based on
a rectangular hyperbola, supporting a higher asymptote and
no inflection points. These functions provide the
equation (YL.fun), the equation
with self-starters for the \code{\link{nls}}
function (NLS.YL) and equation with self-starters for
the \code{\link[drc]{drm}} function in the drc package (DRC.YL)
}
\details{
The Yield-loss equation is parameterised as:
\deqn{ f(x) = \frac{i \, x}{1 + (i \, x)/A}   },
it is convex and asymptotically increasing, while the predictor increases.
The response is zero when the predictor is also zero and it was mainly used
to describe yield losses (in percentage) due to weed competition, expressed
as plant density (Cousens, 1985)
}
\examples{
library(statforbiology)
WeedDens <- c(0, 5, 10, 20, 25)
YieldLoss <- c(0, 17.9, 21.5, 27.4, 29.5)

# nls fit
mod.nls <- nls(YieldLoss ~ NLS.YL(WeedDens, i, A) )
summary(mod.nls)
# drm fit
mod.drc <- drm(YieldLoss ~ WeedDens, fct = DRC.YL() )
summary(mod.drc)

}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}

Cousens, R., 1985. A simple model relating yield loss to weed density. Annals of Applied Biology 107, 239–252. https://doi.org/10.1111/j.1744-7348.1985.tb01567.x
}
\author{
Andrea Onofri
}
