% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_up.R
\name{sum_up}
\alias{sum_up}
\title{Gives summary statistics (corresponds to Stata command summarize)}
\usage{
sum_up(df, ..., d = FALSE, wt = NULL)
}
\arguments{
\item{df}{a data.frame}

\item{...}{Variables to include. Defaults to all non-grouping variables. See the \link[dplyr]{select} documentation.}

\item{d}{Should detailed summary statistics be printed?}

\item{wt}{Weights. Default to NULL.}
}
\value{
a data.frame
}
\description{
Gives summary statistics (corresponds to Stata command summarize)
}
\examples{
library(dplyr)
N <- 100
df <- tibble(
  id = 1:N,
  v1 = sample(5, N, TRUE),
  v2 = sample(1e6, N, TRUE)
)
sum_up(df)
sum_up(df, v2, d = TRUE)
sum_up(df, v2, wt = v1)
df \%>\% group_by(v1) \%>\% sum_up(starts_with("v"))
}
