% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_modify_dimension_records.R
\name{modify_dimension_records}
\alias{modify_dimension_records}
\alias{modify_dimension_records.star_schema}
\title{Apply dimension record update operations}
\usage{
modify_dimension_records(st, updates = record_update_set())

\method{modify_dimension_records}{star_schema}(st, updates = record_update_set())
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{updates}{A \code{record_update_set} object.}
}
\value{
A \code{star_schema} object.
}
\description{
Given a list of dimension record update operations, they are applied on the
dimensions of the \code{star_schema} object. Update operations must be defined
with the set of functions available for that purpose.
}
\details{
When dimensions are defined, records can be detected that must be modified as
part of the data cleaning process: frequently to unify two or more records
due to data errors or missing data. This is not immediate because facts must
be adapted to the new set of dimension instances.

This operation allows us to unify records and automatically propagate
modifications to facts.

The list of update operations can be applied repeatedly to new data received
to be incorporated into the \code{star_schema} object.
}
\examples{
library(tidyr)

st <- st_mrs_age \%>\%
  modify_dimension_records(updates_st_mrs_age)

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{match_records}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection_general}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
