% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTreeBar.R
\name{plotTreeBar}
\alias{plotTreeBar}
\title{Generate a barplot of a Structure or Admixture run.}
\usage{
plotTreeBar(x, facet = TRUE, dendro = NULL, cut = NULL)
}
\arguments{
\item{x}{a single cluster run object of type \code{\link{struct}} or \code{\link{admix}} or Q-matrix}

\item{facet}{whether or not to split the barplot by cluster. This is recommended.}

\item{dendro}{an object of class 'hclust' (defaults to hclust with average linkage)}

\item{cut}{an integer vector output by 'cutree' (defaults to cutree k=ncols(Q))}
}
\description{
Generate a barplot of a Structure or Admixture run.
}
\examples{
# Read file using K = 6 and plot results
k6_data <- exampleStructure("barplot")
# our facetted structure plot with tree
plotTreeBar(k6_data)
# standard 'structure' bar plot with tree
plotTreeBar(k6_data, facet = FALSE)
# Admix example
k3_data <- exampleAdmixture()[[3]]
plotTreeBar(k3_data)
}

