% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-class.R
\name{qts}
\alias{qts}
\alias{as_qts}
\alias{is_qts}
\alias{format.qts}
\title{QTS Class}
\usage{
as_qts(x)

is_qts(x)

\method{format}{qts}(x, digits = 5, ...)
}
\arguments{
\item{x}{A \code{\link[tibble:tibble]{tibble::tibble}} with columns \code{time}, \code{w}, \code{x}, \code{y} and \code{z}.}

\item{digits}{An integer value specifying the number of digits to keep for
printing. Defaults to \code{5L}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \link{qts}.
}
\description{
A collection of functions that implements the QTS class. It currently
provides the \code{\link[=as_qts]{as_qts()}} function for QTS coercion of \code{\link[tibble:tibble]{tibble::tibble}}s
and the \code{\link[=is_qts]{is_qts()}} function for checking if an object is a QTS.
}
\details{
A quaternion time series (QTS) is stored as a \code{\link[tibble:tibble]{tibble::tibble}} with 5
columns:
\itemize{
\item \code{time}: A first column specifying the time points at which quaternions were
collected;
\item \code{w}: A second column specifying the first coordinate of the collected
quaternions;
\item \code{x}: A third column specifying the second coordinate of the collected
quaternions;
\item \code{y}: A fourth column specifying the third coordinate of the collected
quaternions;
\item \code{z}: A fifth column specifying the fourth coordinate of the collected
quaternions.
}
}
\examples{
qts1 <- vespa64$igp[[1]]
qts2 <- as_qts(qts1)
is_qts(qts1)
is_qts(qts2)
}
