% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-sample-class.R
\name{plot.qts_sample}
\alias{plot.qts_sample}
\alias{autoplot.qts_sample}
\title{QTS Sample Visualization}
\usage{
\method{plot}{qts_sample}(x, memberships = NULL, highlighted = NULL, with_animation = FALSE, ...)

\method{autoplot}{qts_sample}(
  x,
  memberships = NULL,
  highlighted = NULL,
  with_animation = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \link{qts_sample}.}

\item{memberships}{A vector coercible as factor specifying a group membership
for each QTS in the sample. Defaults to \code{NULL}, in which case no grouping
structure is displayed.}

\item{highlighted}{A boolean vector specifying whether each QTS in the sample
should be hightlighted. Defaults to \code{NULL}, in which case no QTS is
hightlighted w.r.t. the others.}

\item{with_animation}{A boolean value specifying whether to create a an
animated plot or a static \link[ggplot2:ggplot]{ggplot2::ggplot} object. Defaults to \code{FALSE}
which will create a static plot.}

\item{...}{Further arguments to be passed to methods.}
}
\value{
The \code{\link[=plot.qts_sample]{plot.qts_sample()}} method does not return anything while the
\code{\link[=autoplot.qts_sample]{autoplot.qts_sample()}} method returns a \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
QTS Sample Visualization
}
\examples{
plot(vespa64$igp)
ggplot2::autoplot(vespa64$igp)
}
