% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casewhen.R
\name{casewhen}
\alias{casewhen}
\title{Generate a SQL CASE statement from a mapping file}
\usage{
casewhen(inputfile = NULL, header = FALSE)
}
\arguments{
\item{inputfile}{Mapping dataframe OR path to the mapping file}

\item{header}{If reading a csv file, TRUE if the file includes a header row,
FALSE if it does not include a header row.}
}
\value{
A string that represents the constructed CASE statement
}
\description{
This function constructs a CASE..WHEN,,THEN statement from a mapping file or
dataframe. It assumes that the first column of the mapping data contains the
original WHEN values, and the second column contains the THEN values (the
values to be mapped to.)
}
\examples{
 input <- Data_Frame <- data.frame(Training = c("Strength", "Stamina",
  "Other"), Duration = c(60, 30, 45))
 result <- casewhen(inputfile = input, header = TRUE)
}
