% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.predict.stratafit.R
\name{print.predict.stratafit}
\alias{print.predict.stratafit}
\title{Prints a short summary for the \code{\link{predict.stratafit}()} function.}
\usage{
\method{print}{predict.stratafit}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{is a prediction object generated from \code{\link{predict.stratafit}()}}

\item{digits}{is the number of digits to be displayed in the
model output}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item a table of predictions, standard errors, and confidence
   intervals for each stratum and for the total.
}
}
\description{
This function uses the object that is output from \code{\link{predict.stratafit}()} of class \code{predict.stratafit}..
}
\examples{
data(exampledataset) ## load a toy data set
exampledataset$strata <- c(rep("A", 19), rep("B", 21))
strataobj <- stratafit(formula = counts ~ pred1 + pred2,
 data = exampledataset, stratacol = "strata",
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
predict(strataobj)
}
