% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_frame.R
\name{sp_frame}
\alias{sp_frame}
\alias{sp_unframe}
\title{\code{sp_frame} objects}
\usage{
sp_frame(frame)

sp_unframe(sp_frame)
}
\arguments{
\item{frame}{A sampling frame or analysis data}

\item{sp_frame}{An \code{sp_frame} object.}
}
\value{
An \code{sp_frame} object.
}
\description{
Turn sampling frames or analysis data into an \code{sp_frame} object
  or transform \code{sp_frame} objects back into their original object.
}
\details{
The \code{sp_frame()} function assigns \code{frame} class \code{sp_frame}
  to be used by \code{summary()} and \code{plot()}. \code{sp_frame()} objects
  can sometimes clash with other sf and tidyverse generics, so \code{un_spframe()} removes
  class \code{sp_frame()}, leaving the original classes of \code{frame} intact.
}
\examples{
NE_Lakes <- sp_frame(NE_Lakes)
class(NE_Lakes)
NE_Lakes <- sp_unframe(NE_Lakes)
class(NE_Lakes)
}
