% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecprint.R
\name{vecprint}
\alias{vecprint}
\title{Internal Function: Create Vector to Print}
\usage{
vecprint(x, n.char = 78)
}
\arguments{
\item{x}{Character vector.}

\item{n.char}{The maximum number of characters per line.  The default is 78.}
}
\value{
Character string that is suitable for printing by the functions:
  stop, warning, or cat.
}
\description{
This function takes an input vector and outputs a character string with line
breaks inserted so that, whenever possible, no line in the string exceeds the
input value n.char, which is set to 78 characters by default.  The input
vector is coereced to mode character.  When an element of the input vector is
greater than n.char characters in length, then that element is inserted in
the output character string as an individual line.
}
\examples{
sites <- paste("Site Number", 1:50)
sites.str <- vecprint(sites)
cat(sites.str)

temp <- c(1, 5, 21:25, 33:37)
sites.str <- vecprint(sites[temp])
warning(paste("\\nThe following site ID values were removed from the
  analysis:\\n", sites.str, sep=""))

}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
