% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.dbf.R
\name{read.dbf}
\alias{read.dbf}
\title{Read the dbf File of an ESRI Shapefile}
\usage{
read.dbf(filename = NULL)
}
\arguments{
\item{filename}{Name of the dbf file without any extension.  If filename
equals a dbf file name, then that dbf file is read.  If filename equals
NULL, then all of the dbf files in the working directory are read.  The
default is NULL.}
}
\value{
Data frame composed of either the contents of the single dbf file,
  when filename is provided, or the contents of the dbf file(s) in the
  working directory, when filename is NULL.
}
\description{
This function reads either a single dbf file or multiple dbf files.  For
multiple dbf files, all of the dbf files must have the same variable names.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{readDbfFile}}{C function to read a single dbf file or
      multiple dbf files}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
