% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_spotoroo.R
\name{summary_spotoroo}
\alias{summary_spotoroo}
\title{Summarizing spatiotemporal clustering results}
\usage{
summary_spotoroo(result, cluster = "all")
}
\arguments{
\item{result}{\code{spotoroo} object.
A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{cluster}{Character/Integer. If "all", summarize all clusters.
If an integer vector is given, summarize corresponding
clusters.}
}
\value{
No return value, called for side effects
}
\description{
This function takes a \code{spotoroo} object to produce a summary of the
clustering results. It can be called by \code{\link[=summary.spotoroo]{summary.spotoroo()}}.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                           lon = "lon",
                           lat = "lat",
                           obsTime = "obsTime",
                           activeTime = 24,
                           adjDist = 3000,
                           minPts = 4,
                           minTime = 3,
                           ignitionCenter = "mean",
                           timeUnit = "h",
                           timeStep = 1)


  # Make a summary of all clusters
  summary_spotoroo(result)

  # Make a summary of cluster 1 to 3
  summary_spotoroo(result, 1:3)
}

}
